% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnimalAPD.R
\name{APDRE}
\alias{APDRE}
\title{Activity Probability Density Controlling for Random Effects}
\usage{
APDRE(
  focal,
  contingent,
  RE1,
  RE2 = NULL,
  weibullGLMM = TRUE,
  frechetGLMM = TRUE,
  gammaGLMM = TRUE,
  lognormalGLMM = FALSE,
  invgaussianGLMM = TRUE,
  cores = 1,
  iter = 5000,
  burnin = iter/2,
  center = "pi",
  Reloo = TRUE,
  adapt_delta = 0.95,
  adjust = 1,
  minESS = 1000,
  col = "deeppink3",
  histcol = "deeppink",
  linecol = "black",
  xlimCV = NULL,
  min = TRUE,
  max = TRUE,
  points = TRUE,
  mean = TRUE,
  HDI = TRUE,
  rawmean = FALSE,
  ...
)
}
\arguments{
\item{focal}{Vector of observations in radians of one species/group/individual/etc. for which predictions on another will be made}

\item{contingent}{Vector of observations in radians or output from generalized circular mixture model of activity curves from \code{link[activityGCMM]{GCMM}} of a species/group/individual/etc. from which predictions will be made}

\item{RE1}{Vector identifying a random intercept for observations of the focal to control for hierarchical data (e.g. camera trap IDs)}

\item{RE2}{Optional vector identifying levels of a second random effect, for data with additional hierarchical levels (e.g. study sites, sampling periods, data collection seasons); default is NULL}

\item{weibullGLMM}{Specifies whether to run a weibull GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{frechetGLMM}{Specifies whether to run a frechet GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{gammaGLMM}{Specifies whether to run a Gamma GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{lognormalGLMM}{Specifies whether to run a lognormal GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{invgaussianGLMM}{Specifies whether to run a inverse.gaussian GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{cores}{Number of cores to use when running MCMC chains in parallel; default=1}

\item{iter}{Number of MCMC iteractions per chain; default=5000}

\item{burnin}{Number of MCMC iteractions discarded as burnin; default=iter/2}

\item{center}{Value to use as center of graph; default=pi}

\item{Reloo}{Whether to use reloo when running leave-one-out cross-validation of models (loo)}

\item{adapt_delta}{Value to use for adapt_delta with brms; default=0.95}

\item{adjust}{Smoothing of predicted line; recommended to use default value for observed values and higher value for estimations from circular models}

\item{minESS}{Desired minimum effective sample size; default=1000}

\item{col}{Specifies colour of points for the focal in the graph}

\item{histcol}{Specifies colour of the histogram plot of the posterior distribution}

\item{linecol}{Specifies colour of HDI line in histogram plot of the posterior distribution}

\item{xlimCV}{A vector of two values indicating the x axis limits for the histCV graph}

\item{min}{Whether to include minimum APD on the graph; default=TRUE; default=TRUE}

\item{max}{Whether to include maximum APD on the graph; default=TRUE; default=TRUE}

\item{points}{Whether to include datapoints for observations of the focal on the graph; default=TRUE}

\item{mean}{Whether to include the estimated mean APD from the GLMM on the graph; default=TRUE}

\item{HDI}{Whether to include the estimated 95\% highest density interval of mean APD from the GLMM on the graph; default=TRUE}

\item{rawmean}{Whether to include the raw mean, not correcting for random effects, on the graph; default=FALSE}

\item{...}{Additional parameters}
}
\value{
Prints graph of activity curve and APD estimates from best-fitting GLMM and prints summary of analysis. Returns object of class \code{APD} is returned, containing a list of analysis results and details:

\code{data} List of data used in analysis

\code{output} Matrix with summary output from selected model

\code{distribution} Name of distribution of selected model

\code{model} An object of class \code{brmsfit} containing output from the selected model, including the posterior samples and other information. See \code{\link[brms]{brm}}

\code{CVposterior} Numeric vector of posterior samples for the calculated family-specific population coefficient of variation (CV)

\code{allmodels} List of objects of class \code{brmsfit} containing output from all models from the analysis.

\code{rawvalues} Numeric vector of the raw, uncorrected APD values

\code{rawsummary} List of summary stats of raw APD values
}
\description{
Calculation of animal activity probability density controlling for nested data with random intercepts using Bayesian GLMMs with 'STAN' and \code{\link[brms]{brm}}.
The function can automatically select the statistical distribution that is most appropriate for the dataset (weibull, frechet, gamma, lognormal, inverse gaussian)
using \code{\link[loo]{loo}} and automatically ensures that MCMC chains converge and that a specified minimum effective sample size from the posterior distribution
is achieved. An APD activity curve plot is provided.

Package: AnimalAPD
Version: 1.0.0
Date: 2020-11-08
}
\examples{
data(wolfexample)
data(boarexample)
\donttest{ APDRE(focal=wolfexample$Radians, contingent=boarexample$Radians, 
    RE1=wolfexample$SamplingPeriod, weibullGLMM=TRUE, frechetGLMM=FALSE,
    gammaGLMM=FALSE, lognormalGLMM=FALSE, invgaussianGLMM=FALSE,
    min=TRUE, max=TRUE, points=TRUE, mean=TRUE, HDI=TRUE, rawmean=FALSE) }

}
\seealso{
\code{\link[activityGCMM]{GCMM}} \code{\link[brms]{brm}} \code{\link[loo]{loo}}
}
\author{
Liz AD Campbell
}
\keyword{Bayesian}
\keyword{activity;}
\keyword{cameratrap;}
\keyword{temporal;}
