# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Solve RR-BLUP
#'
#' @description
#' Solves a univariate mixed model of form \eqn{y=X\beta+Mu+e}
#'
#' @param y a matrix with n rows and 1 column
#' @param X a matrix with n rows and x columns
#' @param M a matrix with n rows and m columns
#'
#' @export
solveRRBLUP <- function(y, X, M) {
    .Call(`_AlphaSimR_solveRRBLUP`, y, X, M)
}

#' @title Solve Multivariate RR-BLUP
#'
#' @description
#' Solves a multivariate mixed model of form \eqn{Y=X\beta+Mu+e}
#'
#' @param Y a matrix with n rows and q columns
#' @param X a matrix with n rows and x columns
#' @param M a matrix with n rows and m columns
#' @param tol tolerance for convergence
#' @param maxIter maximum number of iteration
#'
#' @export
solveRRBLUPMV <- function(Y, X, M, maxIter = 1000L, tol = 1e-6) {
    .Call(`_AlphaSimR_solveRRBLUPMV`, Y, X, M, maxIter, tol)
}

#' @title Solve Multikernel RR-BLUP
#'
#' @description
#' Solves a univariate mixed model with multiple random effects.
#'
#' @param y a matrix with n rows and 1 column
#' @param X a matrix with n rows and x columns
#' @param Mlist a list of M matrices
#' @param maxIter maximum number of iteration
#'
#' @export
solveRRBLUPMK <- function(y, X, Mlist, maxIter = 40L) {
    .Call(`_AlphaSimR_solveRRBLUPMK`, y, X, Mlist, maxIter)
}

#' @title Solve RR-BLUP with EM
#'
#' @description
#' Solves a univariate mixed model of form \eqn{y=X\beta+Mu+e} using
#' the Expectation-Maximization algorithm.
#'
#' @param Y a matrix with n rows and 1 column
#' @param X a matrix with n rows and x columns
#' @param M a matrix with n rows and m columns
#' @param Vu initial guess for variance of marker effects
#' @param Ve initial guess for error variance
#' @param tol tolerance for declaring convergence
#' @param maxIter maximum iteration for attempting convergence
#' @param useEM should EM algorithm be used. If false, no estimation of
#' variance components is performed. The initial values are treated as true.
#'
#' @export
solveRRBLUP_EM <- function(Y, X, M, Vu, Ve, tol, maxIter, useEM) {
    .Call(`_AlphaSimR_solveRRBLUP_EM`, Y, X, M, Vu, Ve, tol, maxIter, useEM)
}

#' @title Solve RR-BLUP with EM and 2 random effects
#'
#' @description
#' Solves a univariate mixed model of form \eqn{y=X\beta+M_1u_1+M_2u_2+e} using
#' the Expectation-Maximization algorithm.
#'
#' @param Y a matrix with n rows and 1 column
#' @param X a matrix with n rows and x columns
#' @param M1 a matrix with n rows and m1 columns
#' @param M2 a matrix with n rows and m2 columns
#' @param Vu1 initial guess for variance of the first marker effects
#' @param Vu2 initial guess for variance of the second marker effects
#' @param Ve initial guess for error variance
#' @param tol tolerance for declaring convergence
#' @param maxIter maximum iteration for attempting convergence
#' @param useEM should EM algorithm be used. If false, no estimation of
#' variance components is performed. The initial values are treated as true.
#'
#' @export
solveRRBLUP_EM2 <- function(Y, X, M1, M2, Vu1, Vu2, Ve, tol, maxIter, useEM) {
    .Call(`_AlphaSimR_solveRRBLUP_EM2`, Y, X, M1, M2, Vu1, Vu2, Ve, tol, maxIter, useEM)
}

#' @title Solve RR-BLUP with EM and 3 random effects
#'
#' @description
#' Solves a univariate mixed model of form \eqn{y=X\beta+M_1u_1+M_2u_2+M_3u_3+e} using
#' the Expectation-Maximization algorithm.
#'
#' @param Y a matrix with n rows and 1 column
#' @param X a matrix with n rows and x columns
#' @param M1 a matrix with n rows and m1 columns
#' @param M2 a matrix with n rows and m2 columns
#' @param M3 a matrix with n rows and m3 columns
#' @param Vu1 initial guess for variance of the first marker effects
#' @param Vu2 initial guess for variance of the second marker effects
#' @param Vu3 initial guess for variance of the second marker effects
#' @param Ve initial guess for error variance
#' @param tol tolerance for declaring convergence
#' @param maxIter maximum iteration for attempting convergence
#' @param useEM should EM algorithm be used. If false, no estimation of
#' variance components is performed. The initial values are treated as true.
#'
#' @export
solveRRBLUP_EM3 <- function(Y, X, M1, M2, M3, Vu1, Vu2, Vu3, Ve, tol, maxIter, useEM) {
    .Call(`_AlphaSimR_solveRRBLUP_EM3`, Y, X, M1, M2, M3, Vu1, Vu2, Vu3, Ve, tol, maxIter, useEM)
}

callFastRRBLUP <- function(y, geno, lociPerChr, lociLoc, Vu, Ve, maxIter, nThreads) {
    .Call(`_AlphaSimR_callFastRRBLUP`, y, geno, lociPerChr, lociLoc, Vu, Ve, maxIter, nThreads)
}

callRRBLUP <- function(y, x, geno, lociPerChr, lociLoc, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP`, y, x, geno, lociPerChr, lociLoc, nThreads)
}

callRRBLUP2 <- function(y, x, geno, lociPerChr, lociLoc, Vu, Ve, tol, maxIter, useEM, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP2`, y, x, geno, lociPerChr, lociLoc, Vu, Ve, tol, maxIter, useEM, nThreads)
}

callRRBLUP_D <- function(y, x, geno, lociPerChr, lociLoc, maxIter, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP_D`, y, x, geno, lociPerChr, lociLoc, maxIter, nThreads)
}

callRRBLUP_D2 <- function(y, x, geno, lociPerChr, lociLoc, maxIter, Va, Vd, Ve, tol, useEM, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP_D2`, y, x, geno, lociPerChr, lociLoc, maxIter, Va, Vd, Ve, tol, useEM, nThreads)
}

callRRBLUP_MV <- function(Y, x, geno, lociPerChr, lociLoc, maxIter, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP_MV`, Y, x, geno, lociPerChr, lociLoc, maxIter, nThreads)
}

callRRBLUP_GCA <- function(y, x, geno, lociPerChr, lociLoc, maxIter, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP_GCA`, y, x, geno, lociPerChr, lociLoc, maxIter, nThreads)
}

callRRBLUP_GCA2 <- function(y, x, geno, lociPerChr, lociLoc, maxIter, Vu1, Vu2, Ve, tol, useEM, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP_GCA2`, y, x, geno, lociPerChr, lociLoc, maxIter, Vu1, Vu2, Ve, tol, useEM, nThreads)
}

callRRBLUP_SCA <- function(y, x, geno, lociPerChr, lociLoc, maxIter, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP_SCA`, y, x, geno, lociPerChr, lociLoc, maxIter, nThreads)
}

callRRBLUP_SCA2 <- function(y, x, geno, lociPerChr, lociLoc, maxIter, Vu1, Vu2, Vu3, Ve, tol, useEM, nThreads) {
    .Call(`_AlphaSimR_callRRBLUP_SCA2`, y, x, geno, lociPerChr, lociLoc, maxIter, Vu1, Vu2, Vu3, Ve, tol, useEM, nThreads)
}

#' @title Solve Univariate Model
#'
#' @description
#' Solves a univariate mixed model of form \eqn{y=X\beta+Zu+e}
#'
#' @param y a matrix with n rows and 1 column
#' @param X a matrix with n rows and x columns
#' @param Z a matrix with n rows and m columns
#' @param K a matrix with m rows and m columns
#'
#' @export
solveUVM <- function(y, X, Z, K) {
    .Call(`_AlphaSimR_solveUVM`, y, X, Z, K)
}

#' @title Solve Multivariate Model
#'
#' @description
#' Solves a multivariate mixed model of form \eqn{Y=X\beta+Zu+e}
#'
#' @param Y a matrix with n rows and q columns
#' @param X a matrix with n rows and x columns
#' @param Z a matrix with n rows and m columns
#' @param K a matrix with m rows and m columns
#' @param tol tolerance for convergence
#' @param maxIter maximum number of iteration
#'
#' @export
solveMVM <- function(Y, X, Z, K, tol = 1e-6, maxIter = 1000L) {
    .Call(`_AlphaSimR_solveMVM`, Y, X, Z, K, tol, maxIter)
}

#' @title Solve Multikernel Model
#'
#' @description
#' Solves a univariate mixed model with multiple random effects.
#'
#' @param y a matrix with n rows and 1 column
#' @param X a matrix with n rows and x columns
#' @param Zlist a list of Z matrices
#' @param Klist a list of K matrices
#' @param maxIter maximum number of iteration
#' @param tol tolerance for convergence
#'
#' @export
solveMKM <- function(y, X, Zlist, Klist, maxIter = 40L, tol = 1e-4) {
    .Call(`_AlphaSimR_solveMKM`, y, X, Zlist, Klist, maxIter, tol)
}

writeASGenotypes <- function(g, locations, allLocations, snpchips, names, missing, fname) {
    invisible(.Call(`_AlphaSimR_writeASGenotypes`, g, locations, allLocations, snpchips, names, missing, fname))
}

writeASHaplotypes <- function(g, locations, allLocations, snpchips, names, missing, fname) {
    invisible(.Call(`_AlphaSimR_writeASHaplotypes`, g, locations, allLocations, snpchips, names, missing, fname))
}

calcGenParam <- function(trait, pop, nThreads) {
    .Call(`_AlphaSimR_calcGenParam`, trait, pop, nThreads)
}

getGeno <- function(geno, lociPerChr, lociLoc, nThreads) {
    .Call(`_AlphaSimR_getGeno`, geno, lociPerChr, lociLoc, nThreads)
}

getMaternalGeno <- function(geno, lociPerChr, lociLoc, nThreads) {
    .Call(`_AlphaSimR_getMaternalGeno`, geno, lociPerChr, lociLoc, nThreads)
}

getPaternalGeno <- function(geno, lociPerChr, lociLoc, nThreads) {
    .Call(`_AlphaSimR_getPaternalGeno`, geno, lociPerChr, lociLoc, nThreads)
}

getHaplo <- function(geno, lociPerChr, lociLoc, nThreads) {
    .Call(`_AlphaSimR_getHaplo`, geno, lociPerChr, lociLoc, nThreads)
}

getOneHaplo <- function(geno, lociPerChr, lociLoc, haplo, nThreads) {
    .Call(`_AlphaSimR_getOneHaplo`, geno, lociPerChr, lociLoc, haplo, nThreads)
}

setHaplo <- function(geno, haplo, lociPerChr, lociLoc, nThreads) {
    .Call(`_AlphaSimR_setHaplo`, geno, haplo, lociPerChr, lociLoc, nThreads)
}

writeGeno <- function(geno, lociPerChr, lociLoc, filePath, nThreads) {
    invisible(.Call(`_AlphaSimR_writeGeno`, geno, lociPerChr, lociLoc, filePath, nThreads))
}

writeOneHaplo <- function(geno, lociPerChr, lociLoc, haplo, filePath, nThreads) {
    invisible(.Call(`_AlphaSimR_writeOneHaplo`, geno, lociPerChr, lociLoc, haplo, filePath, nThreads))
}

calcGenoFreq <- function(geno, lociPerChr, lociLoc, nThreads) {
    .Call(`_AlphaSimR_calcGenoFreq`, geno, lociPerChr, lociLoc, nThreads)
}

calcChrFreq <- function(geno) {
    .Call(`_AlphaSimR_calcChrFreq`, geno)
}

getGv <- function(trait, pop, nThreads) {
    .Call(`_AlphaSimR_getGv`, trait, pop, nThreads)
}

getHybridGv <- function(trait, females, femaleParents, males, maleParents, nThreads) {
    .Call(`_AlphaSimR_getHybridGv`, trait, females, femaleParents, males, maleParents, nThreads)
}

getNonFounderIbd <- function(recHist, mother, father) {
    .Call(`_AlphaSimR_getNonFounderIbd`, recHist, mother, father)
}

getFounderIbd <- function(founder, nChr) {
    .Call(`_AlphaSimR_getFounderIbd`, founder, nChr)
}

createIbdMat <- function(ibd, chr, nLoci, ploidy, nThreads) {
    .Call(`_AlphaSimR_createIbdMat`, ibd, chr, nLoci, ploidy, nThreads)
}

cross <- function(motherGeno, mother, fatherGeno, father, femaleMap, maleMap, trackRec, motherPloidy, fatherPloidy, v, p, motherCentromere, fatherCentromere, quadProb, nThreads) {
    .Call(`_AlphaSimR_cross`, motherGeno, mother, fatherGeno, father, femaleMap, maleMap, trackRec, motherPloidy, fatherPloidy, v, p, motherCentromere, fatherCentromere, quadProb, nThreads)
}

createDH2 <- function(geno, nDH, genMap, v, p, trackRec, nThreads) {
    .Call(`_AlphaSimR_createDH2`, geno, nDH, genMap, v, p, trackRec, nThreads)
}

createReducedGenome <- function(geno, nProgeny, genMap, v, p, trackRec, ploidy, centromere, quadProb, nThreads) {
    .Call(`_AlphaSimR_createReducedGenome`, geno, nProgeny, genMap, v, p, trackRec, ploidy, centromere, quadProb, nThreads)
}

#' @title Population variance
#' 
#' @description
#' Calculates the population variance matrix as 
#' opposed to the sample variance matrix calculated 
#' by \code{\link{var}}. i.e. divides by n instead 
#' of n-1
#' 
#' @param X an n by m matrix
#' 
#' @return an m by m variance-covariance matrix
#' 
#' @export
popVar <- function(X) {
    .Call(`_AlphaSimR_popVar`, X)
}

mergeGeno <- function(x, y) {
    .Call(`_AlphaSimR_mergeGeno`, x, y)
}

mergeMultGeno <- function(popList, nInd, nBin, ploidy) {
    .Call(`_AlphaSimR_mergeMultGeno`, popList, nInd, nBin, ploidy)
}

mergeMultIntMat <- function(X, nRow, nCol) {
    .Call(`_AlphaSimR_mergeMultIntMat`, X, nRow, nCol)
}

sampleInt <- function(n, N) {
    .Call(`_AlphaSimR_sampleInt`, n, N)
}

sampAllComb <- function(nLevel1, nLevel2, n) {
    .Call(`_AlphaSimR_sampAllComb`, nLevel1, nLevel2, n)
}

sampHalfDialComb <- function(nLevel, n) {
    .Call(`_AlphaSimR_sampHalfDialComb`, nLevel, n)
}

calcCoef <- function(X, Y) {
    .Call(`_AlphaSimR_calcCoef`, X, Y)
}

#' @title Number of available threads
#'
#' @description
#' Gets the number of available threads by calling the OpenMP function
#' \code{omp_get_max_threads()}
#'
#' @return integer
#'
#' @examples
#' getNumThreads()
#'
#' @export
getNumThreads <- function() {
    .Call(`_AlphaSimR_getNumThreads`)
}

packHaplo <- function(haplo, ploidy, inbred) {
    .Call(`_AlphaSimR_packHaplo`, haplo, ploidy, inbred)
}

MaCS <- function(args, maxSites, inbred, ploidy, nThreads, seed) {
    .Call(`_AlphaSimR_MaCS`, args, maxSites, inbred, ploidy, nThreads, seed)
}

