% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\name{newEmptyPop}
\alias{newEmptyPop}
\title{Creates an empty population}
\usage{
newEmptyPop(ploidy = 2L, simParam = NULL)
}
\arguments{
\item{ploidy}{the ploidy of the population}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}} with
zero individuals
}
\description{
Creates an empty \code{\link{Pop-class}} object with user 
defined ploidy and other parameters taken from simParam.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create empty population
pop = newEmptyPop(simParam=SP)
isPop(pop)

}
