% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{getSnpMap}
\alias{getSnpMap}
\title{Get SNP genetic map}
\usage{
getSnpMap(snpChip = 1, gender = "A", simParam = NULL)
}
\arguments{
\item{snpChip}{an integer. Indicates which SNP
chip's map to retrieve.}

\item{gender}{determines which gender specific map 
is returned. Options are "A" for average map, "F" 
for female map, and "M" for male map. All options are 
equivalent if not using gender specific maps.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a data.frame for the SNP map.
}
\description{
Retrieves the genetic map for a 
given SNP chip.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addSnpChip(5)

#Pull SNP map
getSnpMap(snpChip=1, simParam=SP)

}
