% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GS.R
\name{RRBLUP_D2}
\alias{RRBLUP_D2}
\title{RR-BLUP with Dominance Model 2}
\usage{
RRBLUP_D2(
  pop,
  traits = 1,
  use = "pheno",
  snpChip = 1,
  useQtl = FALSE,
  maxIter = 10,
  Va = NULL,
  Vd = NULL,
  Ve = NULL,
  useEM = TRUE,
  tol = 1e-06,
  useReps = FALSE,
  simParam = NULL,
  ...
)
}
\arguments{
\item{pop}{a \code{\link{Pop-class}} to serve as the training population}

\item{traits}{an integer indicating the trait to model, or a
function of the traits returning a single value.}

\item{use}{train model using phenotypes "pheno", genetic values "gv", 
estimated breeding values "ebv", breeding values "bv", or randomly "rand"}

\item{snpChip}{an integer indicating which SNP chip genotype 
to use}

\item{useQtl}{should QTL genotypes be used instead of a SNP chip. 
If TRUE, snpChip specifies which trait's QTL to use, and thus these 
QTL may not match the QTL underlying the phenotype supplied in traits.}

\item{maxIter}{maximum number of iterations. Only used 
when number of traits is greater than 1.}

\item{Va}{marker effect variance for additive effects. If value is NULL, 
a reasonable starting point is chosen automatically.}

\item{Vd}{marker effect variance for dominance effects. If value is NULL, 
a reasonable starting point is chosen automatically.}

\item{Ve}{error variance. If value is NULL, a 
reasonable starting point is chosen automatically.}

\item{useEM}{use EM to solve variance components. If false, 
the initial values are considered true.}

\item{tol}{tolerance for EM algorithm convergence}

\item{useReps}{should population's reps slot be used to model 
heterogeneous error variance}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments if using a function for 
traits}
}
\description{
Fits an RR-BLUP model for genomic predictions that includes 
dominance effects. This implementation is meant for situations where 
\code{\link{RRBLUP_D}} is too slow. Note that RRBLUP_D2 
is only faster in certain situations. Most users should use 
\code{\link{RRBLUP_D}}.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
SP$setVarE(h2=0.5)
SP$addSnpChip(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Run GS model and set EBV
ans = RRBLUP_D2(pop, simParam=SP)
pop = setEBV(pop, ans, simParam=SP)

#Evaluate accuracy
cor(gv(pop), ebv(pop))

}
