% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PurpleAirSoH_dailyPctValid.R
\name{PurpleAirSoH_dailyPctValid}
\alias{PurpleAirSoH_dailyPctValid}
\title{Daily valid percentage}
\usage{
PurpleAirSoH_dailyPctValid(pat = NULL)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}
}
\description{
The number of valid (\emph{i.e.}, not NA or out-of-spec) sensor 
measurements are summed over the course of a calendar day, then divided by the 
total number of measurements the sensor actually recorded during that day 
(including NA and out-of-spec values) to return a percentage of the total
recorded measurements that are considered plausible.
}
\examples{
library(AirSensor)
  
tbl <- 
  example_pat_failure_B \%>\%
  PurpleAirSoH_dailyPctValid() 

timeseriesTbl_multiPlot(tbl, ylim = c(0,100))
}
