% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VB_analysis.R
\name{VB}
\alias{VB}
\title{Analysis: Von Bertalanffy}
\usage{
VB(
  trat,
  resp,
  initial = NA,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  r2 = "all",
  error = "SE",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  round = NA,
  yname.formula = "y",
  xname.formula = "x",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{initial}{Starting estimates}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{Legend position (\emph{default} is "top")}

\item{r2}{Coefficient of determination of the mean or all values (\emph{default} is all)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{point}{Defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{Shape size}

\item{linesize}{Line size}

\item{pointshape}{Format point (default is 21)}

\item{round}{round equation}

\item{yname.formula}{Name of y in the equation}

\item{xname.formula}{Name of x in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
The Von Bertalanffy model. It's a kind of growth curve for a time series and takes its name from its creator, Ludwig von Bertalanffy. It is a special case of the generalized logistic function. The growth curve (biology) is used to model the average length from age in animals.
}
\details{
The model function for the von Bertalanffy model is:
\deqn{ y = L(1-exp(-k(t-t0)))}
}
\examples{
library(AgroReg)
x=seq(1,20)
y=c(0.10, 0.20, 0.30, 0.40, 0.50, 0.60, 0.70, 0.80, 0.90, 0.91,
    0.92, 0.94, 0.96, 0.98, 1.00, 1.00, 1.00, 1.00, 1.00, 1.00)
VB(x,y)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
