% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEXP_analysis.R
\name{biexponential}
\alias{biexponential}
\title{Analysis: Biexponential Regression}
\usage{
biexponential(
  trat,
  resp,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  scale = "none"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs biexponential regression analysis.
}
\details{
The biexponential model is defined by:
\deqn{f(x, (A1,lrc1,A2,lrc2)) = A1*e{-e^lrc1*x} + A2*e{-e^lrc2*x}}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
biexponential(time,WL)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley \& Sons (p. 330).
}
\seealso{
\link{exponential}, \link{exponential_neg}
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
