% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dunnet_function.R
\name{dunnett}
\alias{dunnett}
\title{Analysis: Dunnett test}
\usage{
dunnett(
  trat,
  resp,
  control,
  model = "DIC",
  block = NA,
  column = NA,
  line = NA,
  alpha.t = 0.05,
  label = "Response"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{control}{Treatment considered control (write identical to the name in the vector)}

\item{model}{Experimental design (DIC, DBC or DQL)}

\item{block}{Numerical or complex vector with blocks}

\item{column}{Numerical or complex vector with columns}

\item{line}{Numerical or complex vector with lines}

\item{alpha.t}{Significance level (\emph{default} is 0.05)}

\item{label}{Variable label}
}
\value{
I return the Dunnett test for experiments in a completely randomized design, randomized blocks or Latin square.
}
\description{
The function performs the Dunnett test
}
\note{
Do not use the "-" symbol or space in treatment names
}
\examples{

#====================================================
# complete randomized design
#====================================================
data("pomegranate")
with(pomegranate,dunnett(trat=trat,resp=WL,control="T1"))

#====================================================
# randomized block design in factorial double
#====================================================
library(AgroR)
data(cloro)
attach(cloro)
respAd=c(268, 322, 275, 350, 320)
a=FAT2DBC.ad(f1, f2, bloco, resp, respAd,
             ylab="Number of nodules",
             legend = "Stages",mcomp="sk")
data=rbind(data.frame(trat=paste(f1,f2,sep = ""),bloco=bloco,resp=resp),
           data.frame(trat=c("Test","Test","Test","Test","Test"),
                      bloco=unique(bloco),resp=respAd))
with(data,dunnett(trat = trat,
                  resp = resp,
                  control = "Test",
                  block=bloco,model = "DBC"))
}
