% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{CMA2}
\alias{CMA2}
\alias{CMA4}
\title{CMA2 and CMA4 constructors.}
\usage{
CMA2(data = NULL, ID.colname = NA, event.date.colname = NA,
  event.duration.colname = NA, followup.window.start = 0,
  followup.window.start.unit = c("days", "weeks", "months", "years")[1],
  followup.window.duration = 365 * 2,
  followup.window.duration.unit = c("days", "weeks", "months",
  "years")[1], observation.window.start = 0,
  observation.window.start.unit = c("days", "weeks", "months",
  "years")[1], observation.window.duration = 365 * 2,
  observation.window.duration.unit = c("days", "weeks", "months",
  "years")[1], date.format = "\%m/\%d/\%Y", summary = NA,
  event.interval.colname = "event.interval",
  gap.days.colname = "gap.days",
  force.NA.CMA.for.failed.patients = TRUE, parallel.backend = c("none",
  "multicore", "snow", "snow(SOCK)", "snow(MPI)", "snow(NWS)")[1],
  parallel.threads = "auto", suppress.warnings = FALSE,
  arguments.that.should.not.be.defined = c(carryover.within.obs.window =
  FALSE, carryover.into.obs.window = FALSE, carry.only.for.same.medication
  = FALSE, consider.dosage.change = FALSE), ...)

CMA4(data = NULL, ID.colname = NA, event.date.colname = NA,
  event.duration.colname = NA, followup.window.start = 0,
  followup.window.start.unit = c("days", "weeks", "months", "years")[1],
  followup.window.duration = 365 * 2,
  followup.window.duration.unit = c("days", "weeks", "months",
  "years")[1], observation.window.start = 0,
  observation.window.start.unit = c("days", "weeks", "months",
  "years")[1], observation.window.duration = 365 * 2,
  observation.window.duration.unit = c("days", "weeks", "months",
  "years")[1], date.format = "\%m/\%d/\%Y", summary = NA,
  event.interval.colname = "event.interval",
  gap.days.colname = "gap.days",
  force.NA.CMA.for.failed.patients = TRUE, parallel.backend = c("none",
  "multicore", "snow", "snow(SOCK)", "snow(MPI)", "snow(NWS)")[1],
  parallel.threads = "auto", suppress.warnings = FALSE,
  arguments.that.should.not.be.defined = c(carryover.within.obs.window =
  FALSE, carryover.into.obs.window = FALSE, carry.only.for.same.medication
  = FALSE, consider.dosage.change = FALSE), ...)
}
\arguments{
\item{data}{A \emph{\code{data.frame}} containing the events used to compute
the CMA. Must contain, at a minimum, the patient unique ID, the event date
and duration, and might also contain the daily dosage and medication type
(the actual column names are defined in the following four parameters).}

\item{ID.colname}{A \emph{string}, the name of the column in \code{data}
containing the unique patient ID; must be present.}

\item{event.date.colname}{A \emph{string}, the name of the column in
\code{data} containing the start date of the event (in the format given in
the \code{date.format} parameter); must be present.}

\item{event.duration.colname}{A \emph{string}, the name of the column in
\code{data} containing the event duration (in days); must be present.}

\item{followup.window.start}{If a \emph{\code{Date}} object, it represents
the actual start date of the follow-up window; if a \emph{string} it is the
name of the column in \code{data} containing the start date of the follow-up
window either as the numbers of \code{followup.window.start.unit} units after
the first event (the column must be of type \code{numeric}) or as actual
dates (in which case the column must be of type \code{Date}); if a
\emph{number} it is the number of time units defined in the
\code{followup.window.start.unit} parameter after the begin of the
participant's first event; or \code{NA} if not defined.}

\item{followup.window.start.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.start} refers to (when a number), or
\code{NA} if not defined.}

\item{followup.window.duration}{either a \emph{number} representing the
duration of the follow-up window in the time units given in
\code{followup.window.duration.unit}, or a \emph{string} giving the column
containing these numbers. Should represent a period for which relevant
medication events are recorded accurately (e.g. not extend after end of
relevant treatment, loss-to-follow-up or change to a health care provider
not covered by the database).}

\item{followup.window.duration.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.duration} refers to, or \code{NA} if not
defined.}

\item{observation.window.start, observation.window.start.unit, observation.window.duration, observation.window.duration.unit}{the definition of the observation window
(see the follow-up window parameters above for details).}

\item{date.format}{A \emph{string} giving the format of the dates used in the
\code{data} and the other parameters; see the \code{format} parameters of the
\code{\link[base]{as.Date}} function for details (NB, this concerns only the
dates given as strings and not as \code{Date} objects).}

\item{summary}{Metadata as a \emph{string}, briefly describing this CMA.}

\item{event.interval.colname}{A \emph{string}, the name of a newly-created
column storing the number of days between the start of the current event and
the start of the next one; the default value "event.interval" should be
changed only if there is a naming conflict with a pre-existing
"event.interval" column in \code{event.info}.}

\item{gap.days.colname}{A \emph{string}, the name of a newly-created column
storing the number of days when medication was not available (i.e., the
"gap days"); the default value "gap.days" should be changed only if there is
a naming conflict with a pre-existing "gap.days" column in \code{event.info}.}

\item{force.NA.CMA.for.failed.patients}{\emph{Logical} describing how the
patients for which the CMA estimation fails are treated: if \code{TRUE}
they are returned with an \code{NA} CMA estimate, while for
\code{FALSE} they are omitted.}

\item{parallel.backend}{Can be "none" (the default) for single-threaded
execution, "multicore"  (using \code{mclapply} in package \code{parallel})
for multicore processing (NB. not currently implemented on MS Windows and
automatically falls back on "snow" on this platform),  or "snow",
"snow(SOCK)" (equivalent to "snow"), "snow(MPI)" or "snow(NWS)" specifying
various types of SNOW clusters (can be on the local machine or more complex
setups -- please see the documentation of package \code{snow} for details;
the last two require packages \code{Rmpi} and \code{nws}, respectively, not
automatically installed with \code{AdhereR}).}

\item{parallel.threads}{Can be "auto" (for \code{parallel.backend} ==
"multicore", defaults to the number of cores in the system as given by
\code{options("cores")}, while for \code{parallel.backend} == "snow",
defaults to 2), a strictly positive integer specifying the number of parallel
threads, or a more complex specification of the SNOW cluster nodes for
\code{parallel.backend} == "snow" (see the documentation of package
\code{snow} for details).}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{arguments.that.should.not.be.defined}{a \emph{list} of argument names
and pre-defined valuesfor which a warning should be thrown if passed to the
function.}

\item{...}{other possible parameters}
}
\value{
An \code{S3} object of class \code{CMA2} (derived from \code{CMA0})
with the following fields:
\itemize{
 \item \code{data} The actual event data, as given by the \code{data}
 parameter.
 \item \code{ID.colname} the name of the column in \code{data} containing the
 unique patient ID, as given by the \code{ID.colname} parameter.
 \item \code{event.date.colname} the name of the column in \code{data}
 containing the start date of the event (in the format given in the
 \code{date.format} parameter), as given by the \code{event.date.colname}
 parameter.
 \item \code{event.duration.colname} the name of the column in \code{data}
 containing the event duration (in days), as given by the
 \code{event.duration.colname} parameter.
 \item \code{event.daily.dose.colname} the name of the column in \code{data}
 containing the prescribed daily dose, as given by the
 \code{event.daily.dose.colname} parameter.
 \item \code{medication.class.colname} the name of the column in \code{data}
 containing the classes/types/groups of medication, as given by the
 \code{medication.class.colname} parameter.
 \item \code{followup.window.start} the beginning of the follow-up window, as
 given by the \code{followup.window.start} parameter.
 \item \code{followup.window.start.unit} the time unit of the
 \code{followup.window.start}, as given by the
 \code{followup.window.start.unit} parameter.
 \item \code{followup.window.duration} the duration of the follow-up window,
 as given by the \code{followup.window.duration} parameter.
 \item \code{followup.window.duration.unit} the time unit of the
 \code{followup.window.duration}, as given by the
 \code{followup.window.duration.unit} parameter.
 \item \code{observation.window.start} the beginning of the observation
 window, as given by the \code{observation.window.start} parameter.
 \item \code{observation.window.start.unit} the time unit of the
 \code{observation.window.start}, as given by the
 \code{observation.window.start.unit} parameter.
 \item \code{observation.window.duration} the duration of the observation
 window, as given by the \code{observation.window.duration} parameter.
 \item \code{observation.window.duration.unit} the time unit of the
 \code{observation.window.duration}, as given by the
 \code{observation.window.duration.unit} parameter.
 \item \code{date.format} the format of the dates, as given by the
 \code{date.format} parameter.
 \item \code{summary} the metadata, as given by the \code{summary} parameter.
 \item \code{event.info} the \code{data.frame} containing the event info
 (irrelevant for most users; see \code{\link{compute.event.int.gaps}} for
 details).
 \item \code{CMA} the \code{data.frame} containing the actual \code{CMA}
 estimates for each participant (the \code{ID.colname} column).
}
}
\description{
Constructs a CMA (continuous multiple-interval measures of medication
availability/gaps) type 2 or type 4 object.
}
\details{
\code{CMA2} considers the total number of days with medication supplied in
all medication events in the observation window, including the last event.
\code{CMA4} is identical to \code{CMA2} except that it is capped at 100\%.

The formula is
\deqn{(number of days supply including last event) / (first to last event)}
Thus, the durations of all events are added up, possibly resulting in an CMA
estimate (much) bigger than 1.0 (100\%)

\code{CMA2} and \code{\link{CMA1}} differ in the inclusion or not of the last
event.
}
\examples{
\dontrun{
cma2 <- CMA2(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             followup.window.start=30,
             observation.window.start=30,
             observation.window.duration=365,
             date.format="\%m/\%d/\%Y"
            );
cma4 <- CMA4(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             followup.window.start=30,
             observation.window.start=30,
             observation.window.duration=365,
             date.format="\%m/\%d/\%Y"
            );}
}
\seealso{
CMAs 1 to 8 are defined in:

Vollmer, W. M., Xu, M., Feldstein, A., Smith, D., Waterbury, A., & Rand, C.
(2012). Comparison of pharmacy-based measures of medication adherence.
\emph{BMC Health Services Research}, \strong{12}, 155.
\url{http://doi.org/10.1186/1472-6963-12-155}.
}
