% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalExpansion.R
\name{clonalExpansion}
\alias{clonalExpansion}
\title{Clonally expands the simulated repertoire generated from fullRepertoire function.}
\usage{
clonalExpansion(ab.repertoire, rep.size, distribution, with.germline,
  dist.parameters)
}
\arguments{
\item{ab.repertoire}{The output from the fullRepertoire function. This takes should
be a nested list, with the first element containing a list of sequence arrays,
the second element containing the corresponding list of names, and the third
element containing a list of trees. The following list elements (containing the
sampling information) will be disregarded for repertoire expansion.}

\item{rep.size}{Controls the total size of the final repertoire. This number
should be greater than the total number of sequences that are provided as input.
Note that currently using the "powerlaw" distribution will return less than the exact
rep.size parameter due to integer values of clonal frequencies.}

\item{distribution}{This parameter controls how the clonal frequency of the
repertoire is distributed. Options include "powerlaw" ("pl"), "identical" ("id")}

\item{with.germline}{Logical - If false, the germline from each lineage will be removed.}

\item{dist.parameters}{Supplies the parameters for how the clonal frequencies should
be distributed.}
}
\value{
Returns a list with three elements. The first list element contains
a character array, with the sequences composing the repertoire. The second element
is a character array with the names of the sequences, and the third element in the list
corresponds to the original phylogenetic trees that served as the basis for expansion
}
\description{
Clonally expands the simulated repertoire generated from fullRepertoire function.
}
\examples{
\dontrun{
clonalExpansion(ab.repertoire=fullRepertoire.output,
 rep.size=3*length(unlist(fullRepertoire.output[[1]])),
 distribution="identical",
 with.germline="FALSE")
}
}
\seealso{
fullRepertoire
}

