% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_solvers.R
\name{lsoda_wrapper}
\alias{lsoda_wrapper}
\title{Wrapper for lsoda}
\usage{
lsoda_wrapper(t, y, model, verbose = FALSE, ...)
}
\arguments{
\item{t}{vector of times.}

\item{y}{vector of biomasses.}

\item{model}{object of class \emph{ATN (Rcpp_parameters_prefs)}.}

\item{verbose}{Boolean, whether a message should be printed when all checks were successful}

\item{...}{additional arguments to pass to `lsoda`}
}
\value{
A matrix for the ODE solution with species as columns and
times as rows.
}
\description{
This is a wrapper to call \code{lsoda} from
\emph{deSolve} and solve the ODE.
Package \code{deSolve} needs to be installed to run
this wrapper.
}
\examples{
library(ATNr)
library(deSolve)
set.seed(123)
masses <- runif(20, 10, 100) #body mass of species
L <- create_Lmatrix(masses, 10, Ropt = 10)
L[L > 0] <- 1
mod <- create_model_Unscaled_nuts(20, 10, 3, masses, L)
mod <- initialise_default_Unscaled_nuts(mod, L)
biomasses <- masses ^ -0.75 * 10 ^ 4 #biomasses of species
biomasses <- append(runif(3, 20, 30), biomasses)
times <- seq(0, 100, 1)
sol <- lsoda_wrapper(times, biomasses, mod)
}
