% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ARPA_Lombardia_W_data.R
\name{get_ARPA_Lombardia_W_data}
\alias{get_ARPA_Lombardia_W_data}
\title{Download weather/meteorological data from ARPA Lombardia website}
\usage{
get_ARPA_Lombardia_W_data(
  ID_station = NULL,
  Year = 2019,
  Frequency = "10mins",
  Var_vec = NULL,
  Fns_vec = NULL,
  by_sensor = 0,
  verbose = T
)
}
\arguments{
\item{ID_station}{Numeric value. ID of the station to consider. Using ID_station = NULL, all the available
stations are selected. Default is ID_station = NULL.}

\item{Year}{Numeric vector. Year(s) of interest. Default is Year = 2019. Specifying more than one year the
code works in parallel computing (half of the available cores) using parLapply() function.}

\item{Frequency}{Temporal aggregation frequency. It can be "10mins", "hourly", "daily", "weekly",
"monthly". Default is Frequency = "10mins"}

\item{Var_vec}{Character vector of variables to aggregate. If NULL (default) all the variables are averaged,
expect for 'Temperature' and 'Snow_height' which are summed.}

\item{Fns_vec}{Character vector of aggregation function to apply to the selected variables. Available functions
are mean, median, min, max, sum and qPP (for the PP-th percentile).}

\item{by_sensor}{Logic value (0 or 1). If 'by_sensor=1', the function returns the observed concentrations
by sensor code, while if 'by_sensor=0' (default) it returns the observed concentrations by station.}

\item{verbose}{Logic value (T or F). Toggle warnings and messages. If 'verbose=T' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose=F' any message about
the progression is suppressed.}
}
\value{
A data frame of class 'data.frame' and 'ARPALdf'. The object is fully compatible with Tidyverse.
}
\description{
'get_ARPA_Lombardia_W_data' returns observed air weather measurements collected by
ARPA Lombardia ground detection system for Lombardy region in Northern Italy.
Available meteorological variables are: temperature (Celsius degrees), rainfall (cm), wind speed (m/s),
wind direction (degrees), relative humidity (%), global_radiation (W/m2)and snow height (cm).
Data are available from 2011 and are updated up to the current date.
For more information about the municipal data visit the section 'Monitoraggio aria' at the webpage:
https://www.dati.lombardia.it/stories/s/auv9-c2sj
}
\details{
More detailed description.
}
\examples{
\donttest{
## Download all the weather measurements at station 100 during 2020. Data have 10 minutes frequency.
get_ARPA_Lombardia_W_data(ID_station = 100, Year = 2020, Frequency = "10mins")
## Download all the weather measurements at station 100 during 2020. Data have 10 minutes frequency.
## Data are reported by sensor.
get_ARPA_Lombardia_W_data(ID_station = 100, Year = 2020, by_sensor = 1)
}

}
