% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.geodesic.R
\name{met.geodesic}
\alias{met.geodesic}
\title{Geodesic distances}
\usage{
met.geodesic(
  M,
  weighted = TRUE,
  shortest.weight = FALSE,
  normalization = TRUE,
  directed = TRUE,
  out = TRUE
)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{weighted}{if \emph{true}, it binarizes the square adjacency matrix M. Geodesic distances and diameter are based only on the presence or absence of edges.}

\item{shortest.weight}{if \emph{false}, it considers the highest met.strength as the shortest path.}

\item{normalization}{normalizes the weights of the links i.e. divides them by the average strength of the network. Argument normalization can't be TRUE when argument weighted is FALSE.}

\item{directed}{if \emph{false}, then it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{out}{if \emph{true}, it considers outgoing ties.}
}
\value{
\itemize{
\item a matrix representing the geodesic distances of the network if argument \emph{M} is a square matrix.
\item A list of matrices if argument \emph{M} is a list of matrices. Each matrix represents the geodesic distances of the corresponding matrix of the list.
}
}
\description{
Calculates the geodesic distances of a network.
}
\details{
Binary network met.density is the ratio of existing links of a network in relation to all potential links.
}
\examples{
met.geodesic(sim.m)
}
\references{
Doreian, P. (1974). On the connectivity of social networks. Journal of Mathematical Sociology, 3(2), 245-258.

Burt, R. S. (1976). Positions in networks. Social forces, 55(1), 93-122.

Opsahl, T., Agneessens, F., & Skvoretz, J. (2010). Node centrality in weighted networks: Generalizing degree and shortest paths. Social networks, 32(3), 245-251.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
