% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.uncertainty.R
\name{sampling.uncertainty}
\alias{sampling.uncertainty}
\title{Metric uncertainty}
\usage{
sampling.uncertainty(
  df,
  nboot,
  metric = "met.strength",
  assoc.indices = FALSE,
  actor = NULL,
  receiver = NULL,
  scan = NULL,
  id = NULL,
  index = "sri",
  progress = TRUE,
  ...
)
}
\arguments{
\item{df}{a data frame of individual interactions or associations}

\item{nboot}{an integer indicating the number of bootstrap wanted.}

\item{metric}{the network metric to compute}

\item{assoc.indices}{a bolean indicating if association indices must be used}

\item{actor}{If argument assoc.indices is FALSE, fill this argument, an integer or a string indicating the column of the individuals performing the behaviour.}

\item{receiver}{If argument assoc.indices is FALSE, fill this argument, an integer or a string indicating the column of the individuals receiving the behaviour.}

\item{scan}{If argument assoc.indices is TRUE, fill this argument, a numeric or character vector representing one or more columns used as scan factors.}

\item{id}{If argument assoc.indices is TRUE, fill this argument, a numeric or character vector indicating the column holding ids of individuals.}

\item{index}{a string indicating the association index to compute.}

\item{progress}{a boolean indicating if function should print progress.}

\item{...}{additional argument related to the computation of the metric declared.
\itemize{
\item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}
}
\value{
3 elements:
\itemize{
\item A matrix in which each column represents a node metric variation through bootstrapping, with the first row representing the original metric.
\item A summary of bootstrap distribution for each node.
\item A plot of metric variations through bootstrap
}
}
\description{
Perform a matrix boostrapping approach to estimate the confidence intervals surrounding each pairwise association.
}
\details{
This process evaluates network metrics uncertainty by performing a boostrap with replacement on the data frame of associations and recomputing the network metric of interest.
}
\examples{
test <- sampling.uncertainty(df = sim.focal.directed, nboot = 100,
                             actor = "actor", receiver = "receiver", 
                             metric = "met.strength")

# objects returned by the function
test$metrics
test$summary
test$plot

# Example with metric extra arguments
sampling.uncertainty(df = sim.focal.directed, nboot = 100,
                     actor = "actor", receiver = "receiver", 
                     metric = "met.affinity", binary = FALSE)
sampling.uncertainty(df = sim.focal.directed, nboot = 100, 
                     actor = "actor", receiver = "receiver", 
                     metric = "met.affinity", binary = TRUE)

# Example with individual associations
sampling.uncertainty(df = sim.grp, nboot = 100, assoc.indices = TRUE, 
                     scan = c("day", "location", "time"), id = "ID")
}
\references{
Lusseau, D., Whitehead, H., & Gero, S. (2009). Incorporating uncertainty into the study of animal social networks. arXiv preprint arXiv:0903.1519.
}
\author{
Sebastian Sosa
}
