% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.assortativity.R
\name{met.assortativity}
\alias{met.assortativity}
\title{Assortativity}
\usage{
met.assortativity(
  M,
  attr,
  se = FALSE,
  weighted = TRUE,
  df = NULL,
  perm.nl = TRUE,
  nperm = NULL
)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{attr}{a factor vector of attributes for categorical assortativity.
a numeric vector of attributes for continuous assortativity.}

\item{se}{a boolean, if \emph{TRUE} it computes the assortativity standard error.}

\item{weighted}{a boolean, if \emph{TRUE} it computes the weighted assortativity version of the network.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{perm.nl}{a boolean, if \emph{TRUE} it permutes argument \emph{attr}.}

\item{nperm}{an integer indicating the number of permutations wanted.}
}
\value{
\itemize{
\item a double representing the assortativity index of the network if argument \emph{M} is a square matrix.
\item A list of doubles if argument \emph{M} is a list of matrices and  if argument \emph{df} is \emph{NULL}. Each double representing the assortativity index of the corresponding matrix of the list.
\item A list of arguments \emph{df} with a new column of network assortativity if argument\emph{df} is not \emph{NULL} and if argument \emph{M} is a list of matrices. The name of the column is adapted according to arguments values \emph{weighted} and \emph{attr}.
\item A list of arguments \emph{df} with a new column of network assortativity if argument \emph{df} is not \emph{NULL}, if argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and if argument \emph{df} is a list of data frames of same length as argument \emph{M}.
}
}
\description{
Calculates the binary or weighted version of vertices Newman's assortativity for categorical or continuous attributes.
}
\details{
Assortativity allows the study of homophily (preferential interaction between nodes with similar attributes) and heterophily (the preferential interaction between nodes with different attributes). Attributes can be individual characteristics such as sex or age, or individual node metrics such as the met.degree.
}
\references{
Newman, M. E. (2003). Mixing patterns in networks. Physical Review E, 67(2), 026126.

Farine, D. R. (2014). Measuring phenotypic assortment in animal social networks: weighted associations are more robust than binary edges. Animal Behaviour, 89, 141-153.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez
}
