% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breslow.day.R
\name{breslow.day}
\alias{breslow.day}
\title{Perform Breslow and Day test}
\usage{
breslow.day(x, y, z, CI.width = 0.95, do.asymp = TRUE, do.CI = TRUE)
}
\arguments{
\item{x}{Binary factor of same length as y, z}

\item{y}{Binary factor of same length as x, z}

\item{z}{Factor of same length as x, y}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{breslow.day()} performs the Breslow and Day test and is used in chapter 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 13.3 from "Applied Nonparametric Statistical Methods" (5th edition)
breslow.day(ch13$machine, ch13$output.status, ch13$material.source)

# Exercise 13.7 from "Applied Nonparametric Statistical Methods" (5th edition)
breslow.day(ch13$medicine, ch13$response, ch13$location)

}
