% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fflm.R
\name{fflm}
\alias{fflm}
\title{Freaking Fask Linear Models}
\usage{
fflm(Y, X, test = "t.HC3")
}
\arguments{
\item{Y}{a numeric array (N x D X S) where D is the number of taxa/genes, N
is the number of samples, and S is the number of posterior samples}

\item{X}{a numeric matrix (N x P) where P is number of covariates}

\item{test}{(default t.HC3), "t", t test is performed for each covariate
(fast); "t.HC0" Heteroskedasticsity-Robust Standard Errors used (HC0;
White's; slower); "t.HC3" (default) Heteroskedasticsity-Robust Standard
Errors used (HC3; unlike HC0, this includes a leverage adjustment and is
better for small sample sizes or when there are data with high leverage;
slowest). To learn more about these, loko at Long and Ervin (2000) Using
Heteroscedasticity Consistent Standard Errors in the Linear Regression
Model, The American Statistician.}
}
\value{
A list of (P x D x S)-arrays with the OLS point estimates, the
standard errors, and the two-sided p-values for each coefficient (P), of
each model fit to each taxa (D) and each posterior sample (S)
}
\description{
Tailored for ALDEx3 where covariates are shared between massive numbers of
linear regressions where only Y is changing.
}
\author{
Justin Silverman
}
