% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmean.R
\name{rmeanDiff.ahr}
\alias{rmeanDiff.ahr}
\title{rmeanDiff.ahr}
\usage{
rmeanDiff.ahr(ahr.obj)
}
\arguments{
\item{ahr.obj}{object of class '"ahr"'}
}
\value{
An object of class '"rmd"', i.e. a list containing:
 \item{L}{time limit, i.e. restricted mean up to time L is calculated}
 \item{rmean1}{restricted mean in group 1}
 \item{rmean2}{restricted mean in group 2}
 \item{rmean.diff}{estimated restricted mean difference}
 \item{var.rmean1}{an estimate of the asymptotic variance of the restricted mean in group 1}
 \item{var.rmean2}{an estimate of the asymptotic variance of the restricted mean in group 2}
 \item{var.rmean.diff}{an estimate of the asymptotic variance of the restricted mean difference}
 \item{Z.rmean}{the standardized test statistic for testing rmean.diff=0}
 \item{p.value}{p-value corresponding to Z.rmean}
}
\description{
Estimate difference of restricted mean survival (based on ahr object as returned by ahr)
}
\details{
This function is usefull if the function 'ahr' has already been called, since the survival estimates
in the object returned by 'ahr' can be reused.
}
\examples{
T <- c(rexp(100, 1), rexp(100, 2))
C <- c(rexp(100, 1), rexp(100, 2))
Y <- pmin(T, C)
D <- T <= C
Z <- rep(c(0,1), c(100, 100))
fit <- avgHR(2, data.frame(Y=Y, D=D, Z=Z), formula=Surv(Y, D) ~ Z)
rmd <- rmeanDiff.ahr(fit)
}
