% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/read_gt3x_Interpolate2.R
\name{interpolate_C}
\alias{interpolate_C}
\alias{Resample}
\alias{Interpolate}
\alias{interpolate_IMU}
\alias{Resample}
\alias{Interpolate}
\alias{sensor_resample}
\alias{Resample}
\alias{Interpolate}
\alias{interpolate_R}
\alias{Resample}
\alias{Interpolate}
\title{Resample a sensor data stream}
\usage{
interpolate_C(original_samples, target_frequency)

interpolate_IMU(original_samples, target_frequency)

sensor_resample(original_samples, target_frequency, method = c("linear_C",
  "linear_R", "IMU"))

interpolate_R(original_samples, target_frequency)
}
\arguments{
\item{original_samples}{numeric. the original data stream}

\item{target_frequency}{numeric. the target sampling frequency}

\item{method}{character. Resampling method to apply. Currently accepts only
\code{interpolate}.}
}
\value{
An appropriately up/down-sampled data stream (numeric vector)
}
\description{
This function was originally developed to correct sensor packets when sampled
more or fewer times than expected over the time interval. However, this
function may have more far-reaching applications.
}
\details{
Currently, resampling is supported via linear interpolation and a
  distance-based approach. Two linear methods are supported, i.e., an R based
  version (\code{method="interpolate_R"}) and a C++ based version
  (\code{method="interpolate_C"}). The latter is used by default. The
  distance-based approach is used for resampling/interpolating SENSOR_DATA
  packets (i.e., IMU data).
}
\examples{
set.seed(14)
target_frequency <- 100

## Downsample linear
   original_samples <- sample(
     seq(1.3,2.4,0.12), 101, replace = TRUE
   )
   down_linear <- sensor_resample(
     original_samples, target_frequency
   )
   head(down_linear)

## Upsample linear
   original_samples <- original_samples[1:99]
   up_linear <- sensor_resample(
     original_samples, target_frequency
   )
   head(up_linear)

## Upsample IMU
   up_IMU <- sensor_resample(
     original_samples, target_frequency, "IMU"
   )
   head(up_IMU)
}
\keyword{internal}
