% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.adpclust.R
\name{plot.adpclust}
\alias{plot.adpclust}
\title{Visualize the result of adpclust()}
\usage{
\method{plot}{adpclust}(x, cols = "default", ...)
}
\arguments{
\item{x}{an object of class "adpclust". Result of adpclust().}

\item{cols}{vector of colors used to distinguish different clusters. Recycled if necessary.}

\item{...}{Not used.}
}
\description{
Depends on the settings of adpclust, draw figures showing silhouette vs. number of clusters, f vs. delta with selected centroids, and original data (projected to the first two principal components if dim > 2) colored by cluster assignments.
}
\examples{
## Load a data set with 3 clusters
data(clust3)
## Automatically select cluster centroids
ans <- adpclust(clust3, centroids = "auto")
plot(ans)
}

