% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cortools.R
\name{multiple.cor}
\alias{multiple.cor}
\title{Multiple correlation
Computes the \href{https://en.wikipedia.org/wiki/Multiple_correlation}{multiple correlation coefficient}
of variables in \code{ymat} with the variable \code{x}}
\usage{
multiple.cor(x, ymat, use = "everything")
}
\arguments{
\item{x}{Either a matrix of variables whose multiple correlation with each other is to be estimated; or a vector of which the multiple correlation with variables in \code{ymat} is to be estimated}

\item{ymat}{a matrix or data.frame of variables of which the multiple correlation with \code{x} is to be estimated}

\item{use}{optional character indicating how to handle missing values (see \link{cor})}
}
\value{
The multiple correlation coefficient
}
\description{
Multiple correlation
Computes the \href{https://en.wikipedia.org/wiki/Multiple_correlation}{multiple correlation coefficient}
of variables in \code{ymat} with the variable \code{x}
}
\examples{
multiple.cor(mtcars[,1],mtcars[,2:4])
}
\seealso{
https://www.personality-project.org/r/book/chapter5.pdf
}
