#' Boston Housing Prices
#' 
#' A dataset containing the prices of houses in the Boston region and a number of features.
#' The dataset and the following description is based on that provided by UCI Machine Learning Repository (\url{http://archive.ics.uci.edu/ml/datasets/Housing}).
#' 
#' \itemize{
#'   \item CRIME: Per capita crime rate by town 
#'   \item ZN: Proportion of residential land zoned for lots over 25,000 sq.ft. 
#'   \item INDUS: Proportion of non-retail business acres per town 
#'   \item CHAS: Charles River dummy variable (= 1 if tract bounds river; 0 otherwise) 
#'   \item NOX: Nitrogen oxides pollutant concentration (parts per 10 million) 
#'   \item ROOMS: Average number of rooms per dwelling 
#'   \item AGE: Proportion of owner-occupied units built prior to 1940 
#'   \item DISTANCE: Weighted distances to five Boston employment centres 
#'   \item HIGHWAY: Index of accessibility to radial highways 
#'   \item TAX: Full-value property-tax rate per ten thousand dollar
#'   \item PUPIL.TEACHER: Pupil-teacher ratio by town 
#'   \item MINORITY: 1000(Bk - 0.63)^2 where Bk is the proportion of blacks by town 
#'   \item LSTAT: Percent lower status of the population 
#'   \item MED.VALUE: Median value of owner-occupied homes in thousands of dollars
#' }
#' 
#' @docType data
#' @keywords datasets
#' @name housing
#' @usage data(housing)
#' @references
#' Frank, A. & Asuncion, A. (2010). UCI Machine Learning Repository [http://archive.ics.uci.edu/ml]. Irvine, CA: University of California, School of Information and Computer Science.
#' 
#' Harrison, D. and Rubinfeld, D.L. Hedonic prices and the demand for clean air, J. Environ. Economics & Management, vol.5, 81-102, 1978.
NULL

#' Ecosystem Multifunctionality
#' 
#' This dataset relates multifunctionality to a number of different biotic and abiotic features in a global survey of drylands. The dataset was obtained from (\url{http://www.sciencemag.org/content/335/6065/214/suppl/DC1}). The dataset contains the features listed below.
#' 
#' \itemize{
#'   \item ELE: Elevation of the site
#'   \item LAT & LONG: Location of the site
#'   \item SLO: Site slope
#'   \item SAC: Soil sand content
#'   \item PCA_C1, PCA_C2, PCA_C3, PCA_C4: Principal components of a  set of 21 climatic features
#'   \item SR: Species richness
#'   \item MUL: Multifunctionality
#' }
#' 
#' @docType data
#' @keywords datasets
#' @name multifunctionality
#' @usage data(multifunctionality)
#' @references
#' Maestre, F. T., Quero, J. L., Gotelli, N. J., Escudero, A., Ochoa, V., Delgado-Baquerizo, M., et al. (2012). Plant Species Richness and Ecosystem Multifunctionality in Global Drylands. Science, 335(6065), 214-218. doi:10.1126/science.1215442
NULL