\name{tempfile}
\alias{tempfile}
\alias{tempdir}
\title{Create Names for Temporary Files}
\description{
  \code{tempfile} returns a vector of character strings which can be used as
  names for temporary files.
}
\usage{
tempfile(pattern = "file", tmpdir = tempdir())
tempdir()
}
\arguments{
  \item{pattern}{a non-empty character vector giving the initial part
    of the name.}
  \item{tmpdir}{a non-empty character vector giving the directory name}
}
\value{
  For \code{tempfile} a character vector giving the names of possible
  (temporary) files. Note that no files are generated by
  \code{tempfile}.

  For \code{tempdir}, the path of the per-session temporary directory.
#ifdef windows

  Both will use backslash as the path separator.
#endif
}
\details{
  If \code{pattern} has length greater than one then the result is of the
  same length giving a temporary file name for each component of
  \code{pattern}.

  The names are very likely to be unique among calls to \code{tempfile}
  in an \R session and across simultaneous \R sessions.  The filenames are
  guaranteed not to be currently in use.

  The file name is made of the pattern and a random suffix in hex.  By
  default, the filenames will be in the directory given by
  \code{tempdir()}.  This will be a subdirectory of the temporary
  directory found by the following rule.  The environment
  variables \env{TMPDIR}, \env{TMP} and \env{TEMP} are checked in turn
  and the first found which points to a writable directory is used:
#ifdef unix
  if none succeeds \file{/tmp} is used.
#endif
#ifdef windows
  if none succeeds the value of \env{R\_USER} (see
  \code{\link{Rconsole}}) is used.  If the path to the directory
  contains a space in any of the components, the path returned will use
  the shortnames version of the path.
#endif
}
\references{
  Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth \& Brooks/Cole.
}
\seealso{\code{\link{unlink}} for deleting files.}
\examples{
tempfile(c("ab", "a b c"))   # give file name with spaces in!

tempdir() # working on all platforms with quite platform dependent result
}
\keyword{file}
