\name{tempfile}
\alias{tempfile}
\title{Create Names for Temporary Files}
\description{
  Returns a vector of character strings which can be used as
  names for temporary files.
}
\usage{
tempfile(pattern = "file")
}
\arguments{
  \item{pattern}{a non-empty character vector giving the initial part
    of the name.}
}
\value{
  A character vector giving the names of possible (temporary) files.

  Note that no files are generated by \code{tempfile}.
}
\details{
  If \code{pattern} has length greater than one then the result is of the
  same length giving a temporary file name for each component of
  \code{pattern}. 

  The names are very likely to be unique among calls to \code{tempfile}
  in an \R session and across simultaneous \R sessions.  The filenames are
  guaranteed not to be currently in use.

#ifdef unix
  The file name is made of the pattern, the process number in hex and a
  random suffix in hex. The filenames will be in the directory given by
  the first found of the environment variables \code{TMP}, \code{TEMP},
  or \code{"/tmp"}.
#endif
#ifdef windows
  The filenames will be in the directory given by the first found of
  the environment variables \code{TMP}, \code{TEMP} and \code{R\_USER}
  (see \code{\link{Rconsole}}). If the path to the directory contains
  a space in any of the components, the path returned will use the
  shortnames version of the path. 
#endif
}
\seealso{\code{\link{unlink}} for deleting files.}
#ifdef unix
\examples{
tempfile(c("ab", "a b c"))   # give file name with spaces in!
## One possibility of getting ALL environment variables;
## compare with `Sys.getenv':
fun <- function() {
  FILE <- tempfile("fun")
  on.exit(unlink(FILE))
  system(paste("printenv >", FILE))
  x <- strsplit(scan(FILE, what = ""), "=")
  v <- n <- character(LEN <- length(x))
  for (i in 1:LEN) {
    n[i] <- x[[i]][1]
    v[i] <- paste(x[[i]][-1], collapse = "=")
  }
  structure(v, names = n)
}
\testonly{str(fun())}
\dontrun{fun()}
}
#endif
\keyword{file}
