\name{image}
\title{Display a color image}
\usage{
image(x, y, z, zlim, col = heat.colors(12),
      add = FALSE, xaxs = "i", yaxs = "i", xlab, ylab, ...)
}
\alias{image}
\arguments{
  \item{x,y}{locations of grid lines at which the values in \code{z} are
    measured.  These must be in ascending order.  By default, equally
    spaced values from 0 to 1 are used.}
  \item{z}{a matrix containing the values to be plotted (\code{NA}s are
    allowed).}
  \item{zlim}{the minimum and maximum \code{z} values for which colors
    will be plotted.  Each of the given colors will be used to color an
    equispaced interval of this range.}
  \item{col}{a list of colors such as that generated by
    \code{\link{rainbow}}, \code{\link{heat.colors}},
    \code{\link{topo.colors}}, \code{\link{terrain.colors}} or similar
    functions.}
  \item{add}{logical; if \code{TRUE}, add to current plot (and disregard
    the following arguments).  This is rarely useful because
    \code{image} ``paints'' over existing graphics.}
  \item{xaxs, yaxs}{style of x and y axis.  The default \code{"i"} is
    appropriate for images.  See \code{\link{par}}.}
  \item{xlab, ylab}{each a character string giving the labels for the x and
    y axis.  Default to the `call names' of \code{x} or \code{y}, or to
    \code{""} if these where unspecified.}
  \item{\dots}{graphical parameters for \code{\link{plot}} may also be
    passed as arguments to this function.}
}
\description{
  Creates a grid of colored or gray-scale rectangles with colors
  corresponding to the values in \code{z}.  This can be used to display
  three-dimensional or spatial data aka ``images''.
  The functions \code{\link{heat.colors}}, \code{\link{terrain.colors}}
  and \code{\link{topo.colors}} create heat-spectrum (red to white) and
  topographical color schemes suitable for displaying ordered data, with
  \code{n} giving the number of colors desired.
}
\note{
  Based on a function by Thomas Lumley
  \email{thomas@biostat.washington.edu}.
}
\seealso{
  \code{\link{contour}},
  \code{\link{heat.colors}}, \code{\link{topo.colors}},
  \code{\link{terrain.colors}}, \code{\link{rainbow}},
  \code{\link{hsv}}, \code{\link{par}}.
}
\examples{
x <- y <- seq(-4*pi, 4*pi, len=27)
r <- sqrt(outer(x^2, y^2, "+"))
image(z = z <- cos(r^2)*exp(-r/6), col=gray((0:32)/32))
image(z=z, axes=F,
      main="Math can be beautiful ...", xlab=expression(cos(r^2) * e^{-r/6}))
contour(z=z, add=T)

data(volcano)
x <- 10*(1:nrow(volcano))
y <- 10*(1:ncol(volcano))
image(x, y, volcano, col = terrain.colors(100), axes = FALSE)
contour(x, y, volcano, levels = seq(90, 200, by=5), add = TRUE, col = "peru")
axis(1, at = seq(100, 800, by = 100))
axis(2, at = seq(100, 600, by = 100))
box()
title(main = "Maunga Whau Volcano", font.main = 4)
}
\keyword{hplot}
\keyword{aplot}
