      SUBROUTINE DQRDC2(X,LDX,N,P,TOL,K,QRAUX,JPVT,WORK)
      INTEGER LDX,N,P
      INTEGER JPVT(1)
      DOUBLE PRECISION X(LDX,1),QRAUX(1),WORK(P,2),TOL
C
C     DQRDC2 USES HOUSEHOLDER TRANSFORMATIONS TO COMPUTE THE QR
C     FACTORIZATION OF AN N BY P MATRIX X.  A LIMITED COLUMN
C     PIVOTING STRATEGY BASED ON THE 2-NORMS OF THE REDUCED COLUMNS
C     MOVES COLUMNS WITH NEAR-ZERO NORM TO THE RIGHT-HAND EDGE OF
C     THE X MATRIX.  THIS STRATEGY MEANS THAT SEQUENTIAL ONE
C     DEGREE-OF-FREEDOM EFFECTS CAN BE COMPUTED IN A NATURAL WAY.
C
C     I AM VERY NERVOUS ABOUT MODIFYING LINPACK CODE IN THIS WAY.
C     IF YOU ARE A COMPUTATIONAL LINEAR ALGEBRA GURU AND YOU REALLY
C     UNDERSTAND HOW TO SOLVE THIS PROBLEM PLEASE FEEL FREE TO
C     SUGGEST IMPROVEMENTS TO THIS CODE.
C
C     ON ENTRY
C
C        X       DOUBLE PRECISION(LDX,P), WHERE LDX .GE. N.
C                X CONTAINS THE MATRIX WHOSE DECOMPOSITION IS TO BE
C                COMPUTED.
C
C        LDX     INTEGER.
C                LDX IS THE LEADING DIMENSION OF THE ARRAY X.
C
C        N       INTEGER.
C                N IS THE NUMBER OF ROWS OF THE MATRIX X.
C
C        P       INTEGER.
C                P IS THE NUMBER OF COLUMNS OF THE MATRIX X.
C
C        TOL     DOUBLE PRECISION
C                TOL IS THE NONNEGATIVE TOLERANCE USED TO
C                DETERMINE THE SUBSET OF THE COLUMNS OF X
C                INCLUDED IN THE SOLUTION.
C
C        JPVT    INTEGER(P).
C                INTEGERS WHICH ARE SWAPPED IN THE SAME WAY AS THE
C                THE COLUMNS OF X DURING PIVOTING.  ON ENTRY THESE
C                SHOULD BE SET EQUAL TO THE COLUMN INDICES OF THE
C                COLUMNS OF THE X MATRIX (TYPICALLY 1 to P).
C
C        WORK    DOUBLE PRECISION(P,2).
C                WORK IS A WORK ARRAY.
C
C     ON RETURN
C
C        X       X CONTAINS IN ITS UPPER TRIANGLE THE UPPER
C                TRIANGULAR MATRIX R OF THE QR FACTORIZATION.
C                BELOW ITS DIAGONAL X CONTAINS INFORMATION FROM
C                WHICH THE ORTHOGONAL PART OF THE DECOMPOSITION
C                CAN BE RECOVERED.  NOTE THAT IF PIVOTING HAS
C                BEEN REQUESTED, THE DECOMPOSITION IS NOT THAT
C                OF THE ORIGINAL MATRIX X BUT THAT OF X
C                WITH ITS COLUMNS PERMUTED AS DESCRIBED BY JPVT.
C
C        K       INTEGER.
C                K CONTAINS THE NUMBER OF COLUMNS OF X JUDGED
C                TO BE LINEARLY INDEPENDENT.
C
C        QRAUX   DOUBLE PRECISION(P).
C                QRAUX CONTAINS FURTHER INFORMATION REQUIRED TO RECOVER
C                THE ORTHOGONAL PART OF THE DECOMPOSITION.
C
C        JPVT    JPVT(K) CONTAINS THE INDEX OF THE COLUMN OF THE
C                ORIGINAL MATRIX THAT HAS BEEN INTERCHANGED INTO
C                THE K-TH COLUMN, IF PIVOTING WAS REQUESTED.
C
C     THIS VERSION DATED 22 AUGUST 1995
C     ROSS IHAKA
C
C     DQRDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.
C
C     BLAS DAXPY,DDOT,DSCAL,DNRM2
C     FORTRAN DABS,DMAX1,MIN0,DSQRT
C
C     INTERNAL VARIABLES
C
      INTEGER I,J,L,LP1,LUP
      DOUBLE PRECISION DNRM2,TT,TTT
      DOUBLE PRECISION DDOT,NRMXL,T
C
C
C     COMPUTE THE NORMS OF THE COLUMNS OF X.
C
      DO 70 J = 1, P
         QRAUX(J) = DNRM2(N,X(1,J),1)
         WORK(J,1) = QRAUX(J)
         WORK(J,2) = QRAUX(J)
         IF(WORK(J,2) .EQ. 0.0D0) WORK(J,2) = 1.0D0
   70 CONTINUE
C
C     PERFORM THE HOUSEHOLDER REDUCTION OF X.
C
      LUP = MIN0(N,P)
      K = LUP + 1
      DO 200 L = 1, LUP
C
C     CYCLE THE COLUMNS FROM L TO LUP LEFT-TO-RIGHT UNTIL ONE
C     WITH NON-NEGLIGIBLE NORM IS LOCATED.  A COLUMN IS CONSIDERED
C     TO HAVE BECOME NEGLIGIBLE IF ITS NORM HAS FALLEN BELOW
C     TOL TIMES ITS ORIGINAL NORM.  THE CHECK FOR L .LE. K
C     AVOIDS INFINITE CYCLING.
C
   80    CONTINUE
         IF (L .GE. K .OR. QRAUX(L) .GE. WORK(L,2)*TOL) GO TO 120
            LP1 = L+1
            DO 100 I=1,N
               T = X(I,L)
               DO 90 J=LP1,LUP
                  X(I,J-1) = X(I,J)
   90          CONTINUE
               X(I,LUP) = T
  100       CONTINUE
            I = JPVT(L)
            T = QRAUX(L)
            TT = WORK(L,1)
            TTT = WORK(L,2)
            DO 110 J=LP1,LUP
               JPVT(J-1) = JPVT(J)
               QRAUX(J-1) = QRAUX(J)
               WORK(J-1,1) = WORK(J,1)
               WORK(J-1,2) = WORK(J,2)
  110       CONTINUE
            JPVT(LUP) = I
            QRAUX(LUP) = T
            WORK(LUP,1) = TT
            WORK(LUP,2) = TTT
            K = K - 1
            GO TO 80
  120    CONTINUE
         IF (L .EQ. N) GO TO 190
C
C           COMPUTE THE HOUSEHOLDER TRANSFORMATION FOR COLUMN L.
C
            NRMXL = DNRM2(N-L+1,X(L,L),1)
            IF (NRMXL .EQ. 0.0D0) GO TO 180
               IF (X(L,L) .NE. 0.0D0) NRMXL = DSIGN(NRMXL,X(L,L))
               CALL DSCAL(N-L+1,1.0D0/NRMXL,X(L,L),1)
               X(L,L) = 1.0D0 + X(L,L)
C
C              APPLY THE TRANSFORMATION TO THE REMAINING COLUMNS,
C              UPDATING THE NORMS.
C
               LP1 = L + 1
               IF (P .LT. LP1) GO TO 170
               DO 160 J = LP1, P
                  T = -DDOT(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)
                  CALL DAXPY(N-L+1,T,X(L,L),1,X(L,J),1)
                  IF (QRAUX(J) .EQ. 0.0D0) GO TO 150
                     TT = 1.0D0 - (DABS(X(L,J))/QRAUX(J))**2
                     TT = DMAX1(TT,0.0D0)
                     T = TT
                     TT = 1.0D0 + 0.05D0*TT*(QRAUX(J)/WORK(J,1))**2
                     IF (TT .EQ. 1.0D0) GO TO 130
                        QRAUX(J) = QRAUX(J)*DSQRT(T)
                     GO TO 140
  130                CONTINUE
                        QRAUX(J) = DNRM2(N-L,X(L+1,J),1)
                        WORK(J,1) = QRAUX(J)
  140                CONTINUE
  150             CONTINUE
  160          CONTINUE
  170          CONTINUE
C
C              SAVE THE TRANSFORMATION.
C
               QRAUX(L) = X(L,L)
               X(L,L) = -NRMXL
  180       CONTINUE
  190    CONTINUE
  200 CONTINUE
      K = K - 1
      RETURN
      END
