% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_get_info.R
\name{zz_get_info}
\alias{zz_get_info}
\title{Get info from Zamzar}
\usage{
zz_get_info(usr = NULL, latest = TRUE)
}
\arguments{
\item{usr}{The username/API key you are using. If not set, the function
will check if a key exists as a \code{ZAMZAR_USR} variable  in \code{.Renviron} and use that.

See: \url{https://developers.zamzar.com/user}}

\item{latest}{Boolean deciding whether or not metadata on all files that
have been submitted within a reasonable time frame should be returned.

If switched to \code{FALSE}, metadata on all files that have been submitted to
the Zamzar API within a reasonable time frame will be returned.

Defaults to \code{TRUE}.

The returned dataframe contains the following columns:
\itemize{
\item \code{id}: The unique file identifier assigned to a file by Zamzar.
\item \code{extension}: The extension representing the format of the file you can download.
\item \code{created_at}: The time at which the file was created at the Zamzar servers.
}}
}
\value{
A dataframe.
}
\description{
Get info on files submitted to Zamzar by account.
}
\details{
Per default \code{zz_get_info()} assumes you want information for the last
submitted file. To get information on all the files that have been submitted
within a reasonable time frame, set parameter \code{latest} to \code{FALSE}.

Please note: objects returned from \code{zz_get_info()} doesn't differentiate
between development or production endpoint. You have to keep track of
this yourself.

Please note that a Zamzar key passed as argument to \code{usr} takes precedence over a
Zamzar key extracted from an \code{.Renviron}.
}
\examples{
\dontrun{
# Provided a valid token in .Renvirion, a dataframe of metadata for the last 
# submitted file will be returned.
zz_get_info()

# Same as above, we're just passing the key in a variable.
zz_get_info(usr = "key")
 
# Provided a valid token, will return metadata for all files
# submitted to the API within a reasonable time frame.
zz_get_info(usr = "key", latest = FALSE)

# Same as above, we're just utilizing .Renviron.
zz_get_info(latest = FALSE)
}
}
