

/*
Adapted from https://github.com/rust-embedded/cortex-m.

Generated asm:
- armv6-m https://godbolt.org/z/1sqKnsY6n
*/

#[cfg(not(portable_atomic_no_asm))]
use core::arch::asm;

pub(super) use core::sync::atomic;

pub(super) type State = u32;


#[inline(always)]
pub(super) fn disable() -> State {
    let primask: State;


    unsafe {

        asm!(
            "mrs {0}, PRIMASK",
            "cpsid i",
            out(reg) primask,
            options(nostack, preserves_flags),
        );
    }
    primask
}






#[inline(always)]
pub(super) unsafe fn restore(primask: State) {
    if primask & 0x1 == 0 {


        unsafe {

            asm!("cpsie i", options(nostack, preserves_flags));
        }
    }
}
