% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpolylogMoments.R
\name{zipfpolylogMoments}
\alias{zipfpolylogMoments}
\title{Moments of the Zipf-Polylog Distribution.}
\usage{
zipfpolylogMoments(k, alpha, beta, tolerance = 10^(-4), nSum = 1000)
}
\arguments{
\item{k}{Order of the moment to compute.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > k + 1}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta \in (-\infty, +\infty)}).}

\item{tolerance}{Tolerance used in the calculations (default = \eqn{10^{-4}}).}

\item{nSum}{The number of terms used for computing the Polylogarithm function (default = 1000).}
}
\value{
A positive real value corresponding to the k-th moment of the distribution.
}
\description{
General function to compute the k-th moment of the ZipfPolylog distribution for any integer value \eqn{k \geq 1},
when it exists. #'
For k = 1, this function returns the same value as the \link{zipfpolylogMean} function.
}
\details{
The k-th moment of the Zipf-Polylog distribution is always finite, but,
for \eqn{\alpha >1} and \eqn{\beta = 0} the k-th moment is only finite for all \eqn{\alpha > k + 1}.
It is computed by calculating the partial sums of the serie, and stopping when two
consecutive partial sums differ less than the \code{tolerance} value.
The value of the last partial sum is returned.
}
\examples{
zipfpolylogMoments(1, 0.2, 0.90)
zipfpolylogMoments(3, 4.5, 0.90,  1*10^(-3))
}
