% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpolylogMean.R
\name{zipfpolylogMean}
\alias{zipfpolylogMean}
\title{Expected value of the ZipfPolylog distribution.}
\usage{
zipfpolylogMean(alpha, beta, tolerance = 10^(-4))
}
\arguments{
\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 2}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta \in (-\infty, +\infty)}).}

\item{tolerance}{Tolerance used in the calculations (default = \eqn{10^{-4}}).}
}
\value{
A positive real value corresponding to the mean value of the ZipfPolylog distribution.
}
\description{
Computes the expected value of the ZipfPolylog distribution for given values of parameters
\eqn{\alpha} and \eqn{\beta}.
}
\examples{
zipfpolylogMean(0.5, 0.8)
zipfpolylogMean(2.5, 0.8, 10^(-3))
}
