% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{write_json_str}
\alias{write_json_str}
\title{Convert R object to JSON string}
\usage{
write_json_str(x, opts = list(), ...)
}
\arguments{
\item{x}{the object to be encoded}

\item{opts}{Named list of serialization options. Usually created by \code{\link[=opts_write_json]{opts_write_json()}}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_write_json]{opts_write_json()}}}
}
\value{
Single string containing JSON
}
\description{
Convert R object to JSON string
}
\examples{
write_json_str(head(iris, 3), pretty = TRUE)
}
\seealso{
Other JSON Serializer: 
\code{\link{write_json_file}()},
\code{\link{write_json_raw}()},
\code{\link{write_ndjson_file}()},
\code{\link{write_ndjson_raw}()},
\code{\link{write_ndjson_str}()}
}
\concept{JSON Serializer}
