% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{read_json_str}
\alias{read_json_str}
\title{Convert JSON in a character string to R}
\usage{
read_json_str(str, opts = list(), ...)
}
\arguments{
\item{str}{a single character string}

\item{opts}{Named list of options for parsing. Usually created by \code{opts_read_json()}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_read_json]{opts_read_json()}}}
}
\value{
R object
}
\description{
Convert JSON in a character string to R
}
\examples{
read_json_str("4294967297", opts = opts_read_json(int64 = 'string'))
}
\seealso{
Other JSON Parsers: 
\code{\link{read_json_conn}()},
\code{\link{read_json_file}()},
\code{\link{read_json_raw}()},
\code{\link{read_ndjson_file}()},
\code{\link{read_ndjson_raw}()},
\code{\link{read_ndjson_str}()}
}
\concept{JSON Parsers}
