% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{chilliwack_bt_05}
\alias{chilliwack_bt_05}
\title{Chilliwack Lake Bull Trout Populations Parameters (2005)}
\format{
An object of class \code{\link[=ypr_populations]{ypr_populations()}}.
}
\usage{
chilliwack_bt_05
}
\description{
The populations parameters for Bull Trout in Chilliwack Lake from Taylor
(2005)
}
\examples{
chilliwack_bt_05
yield <- ypr_tabulate_yield(chilliwack_bt_05, type = "optimal")
yield$pi <- round(yield$pi, 2)
yield <- yield[c("Llo", "Hm", "Rk", "pi")]
yield <- tidyr::spread(yield, Rk, pi)
yield <- yield[order(-yield$Hm), ]
yield
\dontrun{
ypr_plot_yield(chilliwack_bt_05, plot_values = FALSE) +
  ggplot2::facet_grid(Rk ~ Hm) +
  ggplot2::aes(group = Llo, linetype = Llo)
}
}
\references{
Taylor, J.L. 2005. Sustainability of the Chilliwack Lake Char
Fishery. Ministry of Water, Land and Air Protection, Surrey, B.C.
}
\seealso{
Other populations: 
\code{\link{as_ypr_populations}()},
\code{\link{ypr_plot_yield}()},
\code{\link{ypr_populations_expand}()},
\code{\link{ypr_populations}()},
\code{\link{ypr_tabulate_sr}()},
\code{\link{ypr_tabulate_yields}()},
\code{\link{ypr_tabulate_yield}()}

Other data: 
\code{\link{adams_bt_03}},
\code{\link{kootenay_bt_13}},
\code{\link{kootenay_rb_13}},
\code{\link{kootenay_rb}},
\code{\link{quesnel_bt}},
\code{\link{quesnel_lt}},
\code{\link{quesnel_rb}}
}
\concept{data}
\concept{populations}
\keyword{datasets}
