% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.ycevo}
\alias{augment.ycevo}
\title{Augment data with predicted discount functions and yield curves}
\usage{
\method{augment}{ycevo}(x, newdata = NULL, loess = TRUE, ...)
}
\arguments{
\item{x}{A \link{ycevo} object}

\item{newdata}{A data frame containing time-to-maturity in years \code{tau} and
the quotation date at which the discount functions and the yield curves are to
be predicted. The quotation date is to be named after the quotation
date column in \code{x}, which is also the name of the quotation date column of
the \code{data} argument in \code{\link[=ycevo]{ycevo()}} that produces \code{x}. The default is \code{qdate}.}

\item{loess}{Logical. If TRUE, the returned discount functions and yield curves
are loess smoothed.}

\item{...}{Additional arguments required for generic consistency. Currently
not used. Warning: A misspelled argument will not raise an error. The
misspelled argument will be either disregarded, or the default value will
be applied if one exists.}
}
\value{
\code{newdata} augmented with \code{.discount} and \code{.yield} for the discount
function and the yield curve respectively.
}
\description{
Augment data with predicted discount functions and yield curves
}
\details{
If \code{newdata} is not provided, returns the discount function and yield curve
at the specified estimation points in \code{\link[=ycevo]{ycevo()}}.

If \code{newdata} is provided, the discount functions at the time-to-maturities
specified in \code{newdata} are generated from loess smoothing (see
\code{\link[stats:loess]{stats::loess()}}), and interpolated to produce the discount function values at the
quotation date specified in \code{newdata}, before being converted to the yield curves.
}
\examples{
# Simulating bond data
bonds <- ycevo_data(n = 10)
\donttest{
# Estimation can take up to 30 seconds
res <- ycevo(bonds, x = lubridate::ymd("2023-03-01"))
# Augmentation
augment(res)
}

}
\seealso{
\code{\link[=ycevo]{ycevo()}}, \code{\link[=predict.ycevo]{predict.ycevo()}}
}
