% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_filter.R
\name{linear_filter}
\alias{linear_filter}
\title{Fit a linear filter over a label matrix}
\usage{
linear_filter(y, alpha = 0.25, na.rm = FALSE)
}
\arguments{
\item{y}{a label matrix}

\item{alpha}{a vector with 4 alpha values, or a single alpha value
which then is used for all 4 alphas.}

\item{na.rm}{a logical value indicating whether missing values should
be removed before calculating the row-, column- and total means.}
}
\value{
an object of class \code{\link[=linearFilter-class]{linearFilter}}
}
\description{
This function fits a linear filter over a label matrix. It calculates
the row, column and total means, and uses those to construct the linear
filter.
}
\details{
If there are missing values and they are removed before calculating the
means, a warning is issued. If \code{na.rm = FALSE} and there are
missing values present, the outcome is, by definition, a matrix filled
with NA values.
}
\examples{
data(drugtarget)
linear_filter(drugTargetInteraction, alpha = 0.25)
linear_filter(drugTargetInteraction, alpha = c(0.1,0.1,0.4,0.4))

}
