% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters_tskrrImpute.R
\name{has_imputed_values}
\alias{has_imputed_values}
\alias{which_imputed}
\alias{is_imputed}
\title{Getters for tskrrImpute objects}
\usage{
has_imputed_values(x)

which_imputed(x)

is_imputed(x)
}
\arguments{
\item{x}{a \code{\link[xnet:tskrrImpute-class]{tskrrImpute}} object or
an object inheriting from \code{tskrrImpute}.}
}
\value{
For \code{has_imputed_values}: a logical value indicating whether
the model has imputed values. If \code{x} is not some form of a
\code{\link{tskrr}} model, the function will return an error.

For \code{which_imputed}: a integer vector with the positions
for which the values are imputed.

for \code{is_imputed}: a matrix of the same dimensions as the
label matrix. It contains the value \code{FALSE} at positions that
were not imputed, and \code{TRUE} at positions that were.
}
\description{
The functions described here are convenience functions to get
information out of a \code{\link[xnet:tskrrImpute-class]{tskrrImpute}}
object.
}
\examples{

data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)

naid <- sample(length(drugTargetInteraction), 30)
drugTargetInteraction[naid] <- NA

impmod <- impute_tskrr(drugTargetInteraction, targetSim, drugSim)

has_imputed_values(mod)
has_imputed_values(impmod)

# For illustration: extract imputed values
id <- is_imputed(impmod)
fitted(impmod)[id]

}
