% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vhas.R
\name{vhas}
\alias{vhas}
\alias{vhas_no_dup_pairs}
\alias{vhas_valid_weights}
\title{Boolean flags for properties of candidate and validated xmap links (internal)}
\usage{
vhas_no_dup_pairs(v_from, v_to)

vhas_valid_weights(v_from, v_weights, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{v_from, v_to, v_weights}{equal length vectors containing the source-target node pairs}

\item{tol}{numeric \eqn{\ge 0}. Ignore differences smaller than `tol`.
Passed through to the `tolerance` arg of `base::all.equal()`.}
}
\value{
TRUE or FALSE
}
\description{
`vhas_*()` functions check properties of xmap links and/or candidate links.
The functions only accepts equal length vector inputs to support multiple link formats,
but does not check if the inputs are from the same xmap.
}
\section{Functions}{
\itemize{
\item \code{vhas_no_dup_pairs()}: Returns TRUE if xmap does not have
duplicate pairs of source-target nodes (irrespective of weights)

\item \code{vhas_valid_weights()}: Returns TRUE if all weights for a given `from` label
sum to one (approximately)

}}
\keyword{internal}
