% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalGene.R
\name{EvalGeneStoch}
\alias{EvalGeneStoch}
\title{Evaluates a gene in a stochastic problem environment.}
\usage{
EvalGeneStoch(gene, lF)
}
\arguments{
\item{gene}{A gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A gene with the elements
  \itemize{
  \item  \code{$evaluated}: Boolean.
  \item  \code{$evalFail}:  Boolean. 
  \item  \code{$fit}:       Mean fitness of gene. 
  \item  \code{$gene1}:     Gene.  
  \item  \code{$obs}:       Number of evaluations of gene.
  \item  \code{$var}:       Variance of fitness.  
  \item  \code{$sigma}:     Standard deviation of fitness.
  }
}
\description{
\code{EvalGeneStoch()} evaluates a gene in
             a stochastic problem environment.
}
\details{
In a stochastic problem environment, the expected fitness
         is maximized. The computation of the expectation is 
         done by incrementally updating the mean.
         For this, need the number of evaluations of the gene 
         (\code{$obs} of the gene).
         In addition, we compute the incremental variance 
         of the expected fitness 
         stored in \code{$var}.  
         The standard deviation is then \code{gene$var/gene$obs}.

         If the evaluation of the fitness function of the 
         problem environment fails, we catch the error and 
         return \code{NA} for the first evaluation of the gene.
         If the gene has been evaluated, we return the old gene.
}
\examples{
DeJongF4<-DeJongF4Factory()
lF<-NewlFevalGenes(DeJongF4)
g1<-list(evaluated=FALSE, evalFail=FALSE, fit=0, gene1=c(1.0, -1.5))
g1
g2<-EvalGeneStoch(g1, lF)
g2
g3<-EvalGeneStoch(g2, lF)
g3
g4<-EvalGeneStoch(g3, lF)
g4
g5<-EvalGeneStoch(g4, lF)
g5
}
\seealso{
Other Evaluation Functions: 
\code{\link{EvalGene}()},
\code{\link{EvalGeneDet}()},
\code{\link{EvalGeneR}()},
\code{\link{EvalGeneU}()}
}
\concept{Evaluation Functions}
