% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basefunctions.R
\name{identical_cols}
\alias{identical_cols}
\title{Find and optionally remove identical columns in a data frame.}
\usage{
identical_cols(
  df,
  interactive = TRUE,
  remove_duplicates = TRUE,
  clean_names = TRUE,
  print_duplicates = TRUE
)
}
\arguments{
\item{df}{A data frame or tibble.}

\item{interactive}{Logical. If TRUE, the function prompts the user to choose how
to handle duplicated columns. Defaults to TRUE.}

\item{remove_duplicates}{Logical. If TRUE, removes duplicated columns. Defaults to TRUE.}

\item{clean_names}{Logical. If TRUE, cleans column names by removing trailing
"..." followed by digits. Defaults to TRUE.}

\item{print_duplicates}{Logical. If TRUE, prints the groups of duplicated columns.
Defaults to TRUE.}
}
\value{
A data frame with optionally removed and renamed columns.
}
\description{
This function identifies columns with identical values in a data frame and
provides options to remove them, clean column names, and print the duplicated groups.
It also includes an interactive mode where the user can choose to remove all,
some, or none of the duplicated columns.
}
\examples{
library(tibble)

dummy <- tibble(
  A...1 = rnorm(10),
  A...2 = A...1,
  C = sample(letters, 10),
  A...4 = A...1,
  E = sample(1:10, 10),
  `F` = C
)

# Example usage:
identical_cols(dummy) # Interactive removal
identical_cols(dummy, remove_duplicates = FALSE) # Find identical columns only
identical_cols(dummy, print_duplicates = FALSE) # Interactive removal, no print
identical_cols(dummy, clean_names = FALSE) # Interactive removal, no clean names
identical_cols(dummy, interactive = FALSE) # Non interactive removal of all duplicates.

}
