% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifFixedModif.R
\name{identifFixedModif}
\alias{identifFixedModif}
\title{Identify Fixed Modifications}
\usage{
identifFixedModif(
  prot,
  expMass,
  minFragSize = 5,
  maxFragSize = 60,
  indexStart = 1,
  suplPepTab = NULL,
  internFra = TRUE,
  chargeCatchFilter = TRUE,
  maxMod = c(p = 3, h = 1, k = 1, o = 1, m = 1, n = 1, u = 1, r = 1, s = 1),
  modTy = NULL,
  specModif = NULL,
  knownMods = NULL,
  identMeas = "ppm",
  limitIdent = 5,
  filtAmbiguous = FALSE,
  recalibrate = FALSE,
  massTy = "mono",
  prefFragPat = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{prot}{(character) amino-acid sequene of peptide or protein}

\item{expMass}{(numeric) experimental masses to identify peptides from}

\item{minFragSize}{(integer) min number of AA residues for considering peptide fragments}

\item{maxFragSize}{(integer) max number of AA residues for considering peptide fragments}

\item{indexStart}{(integer) for starting at correct index (if not 1)}

\item{suplPepTab}{(matrix) additional peptides to be add to theoretical peptides}

\item{internFra}{(logical) decide whether internal fragments should be consiered}

\item{chargeCatchFilter}{(logical) by default remove all peptides not containing charge-catching (polar) AAs (K, R, H, defined via \code{.chargeCatchingAA()} )}

\item{maxMod}{(integer) maximum number of residue modifications to be consiered in fragments (values >1 will increase complexity and RAM consumption)}

\item{modTy}{(character) type of fixed and variable modifications}

\item{specModif}{(list) supplemental custom fixed or variable modifications (eg Zn++ at given residue)}

\item{knownMods}{(character) optional custom alternative to \code{AAfragSettings(ou="all")$knownMods}}

\item{identMeas}{(character) default 'ppm'}

\item{limitIdent}{(character) thershold for identification in 'identMeas' units}

\item{filtAmbiguous}{(logical) allows filtering/removing ambiguous results (ie same mass peptides)}

\item{recalibrate}{(logical or numeric) may be direct recalibration-factor (numeric,length=1), if 'TRUE'  fresh determination of 'recalibFact' or 'FALSE' (no action);  final recalibration-factor used exported in result as $recalibFact}

\item{massTy}{(character) 'mono' or 'average'}

\item{prefFragPat}{(numeric) pattern for preferential fragmentation (see also Haverland 2017), if \code{NULL} default will be taken (in function \code{evalIsoFragm}) from \code{.prefFragPattern()}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages and objects exportet to current session for debugging}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This function returns a list with $massMatch (list of exerimental peptides matching to one or more predicted), $preMa (predicted ions, including fixed modif), $pepTab (predicted neutral peptides, wo modifications), $expMa (experimental mass from input), $recalibFact (recalibration factor as from input), $docTi (time for calculations)
}
\description{
Identify peptide/protein fragments based on experimental m/z values 'expMass' for given range of aa-length.
Internally all possible fragments will be predicted and their mass compared to the experimental values (argument \code{expMass}).
}
\details{
The main matching results are in output$massMatch : This list has one entry for each predicted mass where some matches were found. 
Thus, the names of the list-elements design the index from argument \code{expMass}. 
Each list-element contains a numeric vector giving the difference observed to predicted, the names design the unique predicted peptide index/number from output$preMa[,"no"]

The main element of the output is the $massMatch -list, which is in the format of  \code{\link[wrMisc]{findCloseMatch}}.
Thus, the list-elements names represent the line-number of mass-predictions and the values the delta-mass and their names the position of the initial query.
}
\examples{
pro3 <- "HLVDEPQNLIK"
exp3 <- c( b4=465.2451, b5=594.2877, b6=691.3404,  y7=841.4772, y6=712.4347, y5=615.3819)
ident3 <- identifFixedModif(prot=pro3, expMass=exp3, minFragSize=4, 
  maxFragSize=60, modTy=list(basMod=c("b","y")))
ident3$massMatch                                                                                              
## as human readable table:
ident3$preMa[ ident3$preMa[,"no"] \%in\% (names(ident3$massMatch)),]
}
\seealso{
\code{\link{makeFragments}}, \code{\link{identifVarModif}}, \code{\link{identifyPepFragments}}, \code{\link[wrMisc]{findCloseMatch}}
}
