% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull-cited-refs.R
\name{pull_cited_refs}
\alias{pull_cited_refs}
\title{Pull cited references}
\usage{
pull_cited_refs(uts, sid = auth(Sys.getenv("WOS_USERNAME"),
  Sys.getenv("WOS_PASSWORD")), ...)
}
\arguments{
\item{uts}{Vector of UTs (i.e., publications) whose cited references you want.}

\item{sid}{Session identifier (SID). The default setting is to get a fresh
SID each time you query WoS via a call to \code{\link{auth}}. However,
you should try to reuse SIDs across queries so that you don't run into the
throttling limits placed on new sessions.}

\item{...}{Arguments passed along to \code{\link[httr]{POST}}.}
}
\value{
A data frame with the following columns:
 \describe{
   \item{ut}{The publication that is doing the citing. These are the UTs that
   you submitted to \code{pull_cited_refs}. If one of your publications
   doesn't have any cited refs, it will not appear in this column.}

   \item{doc_id}{The cited ref's document identifier (similar to a UT).}

   \item{title}{Roughly equivalent to the cited ref's title.}

   \item{journal}{Roughly equivalent to the cited ref's journal.}

   \item{author}{The cited ref's first author.}

   \item{tot_cites}{The total number of citations the cited ref has received.}

   \item{year}{The cited ref's publication year.}

   \item{page}{The cited ref's page number.}

   \item{volume}{The cited ref's journal volume.}
 }
}
\description{
Pull cited references
}
\examples{
\dontrun{

sid <- auth("your_username", password = "your_password")
uts <- c("WOS:000362312600021", "WOS:000439855300030", "WOS:000294946900020")
pull_cited_refs(uts, sid)
}
}
