% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wish_ps.R
\name{wish_ps}
\alias{wish_ps}
\title{Coefficient Matrix \eqn{\mathcal{H}_k}}
\usage{
wish_ps(k, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\mathcal{H}_k} matrix}

\item{alpha}{The type of Wishart distribution (\eqn{\alpha = 2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
A coefficient matrix \eqn{\mathcal{H}_k} that allows us to compute
the expected value of a power-sum symmetric function of \eqn{W},
where \eqn{W \sim W_m^{\beta}(n,\Sigma)}.  The matrix is represented as a
3-dimensional array where each slice along the third dimension represents
a coefficient matrix of the polynomial in descending powers of \eqn{n}.
}
\description{
This function computes the coefficient matrix \eqn{\mathcal{H}_k} that allows us to compute
the expected value of a power-sum symmetric function of \eqn{W}, where
\eqn{W \sim W_m^{\beta}(n,\Sigma)}.
}
\examples{
# Example 1:
wish_ps(3) # For real Wishart distribution with k = 3

# Example 2:
wish_ps(4, 1) # For complex Wishart distribution with k = 4

# Example 3:
wish_ps(2, 1/2) # For quaternion Wishart distribution with k = 2

}
