% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.spectra.gradient.R
\name{map.spectra.gradient}
\alias{map.spectra.gradient}
\title{Colors and plots each spectra based on the associated concentration of the outcome variable}
\usage{
map.spectra.gradient(
  xblock = NULL,
  yblock = NULL,
  legend.title = "Gradient",
  plot.title = "Spectra with gradient based on Y variable",
  xlab = "Wavelength",
  ylab = "Absorbance",
  grad = 10,
  l.width = 0.75,
  col.legend = NULL
)
}
\arguments{
\item{xblock}{A matrix containing one spectra for each observation.}

\item{yblock}{A vector containing the concentration associated to each spectra in the \emph{xblock} matrix.}

\item{legend.title}{Title of the legend which displays the gradient.}

\item{plot.title}{Title of the plot.}

\item{xlab}{Title of the x axis.}

\item{ylab}{Title of the y axis.}

\item{grad}{Number of colors for the gradient's palette.}

\item{l.width}{Width of each spectra.}

\item{col.legend}{Deletes presence of the legend.}
}
\value{
Plot with spectra of all observations, mapped with the intensity of the associated concentration.
}
\description{
Colors and plots each spectra based on the associated concentration of the outcome variable
}
\examples{
data(beer)
X=beer[,2:ncol(beer)]
names(X)=convert.names.wl(1100,2250,2)
Y=unlist(beer[,1])
map.spectra.gradient(X,Y)
}
