% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levels_date.R
\name{select_week_level}
\alias{select_week_level}
\alias{select_week_level.when}
\title{Configure week level}
\usage{
select_week_level(td, include_all, exclude_all, week, year_week)

\method{select_week_level}{when}(
  td,
  include_all = FALSE,
  exclude_all = FALSE,
  week = NULL,
  year_week = NULL
)
}
\arguments{
\item{td}{A \code{when} object.}

\item{include_all}{A boolean, include all fields of the level.}

\item{exclude_all}{A boolean, exclude all fields of the level.}

\item{week}{A boolean, include the week number.}

\item{year_week}{A boolean, include the year-week combination.}
}
\value{
A \code{when} object.
}
\description{
When the dimension is defined as a date type, using this function we can select
the week level and its attributes to include in it: week and year_week.
}
\details{
The \code{include_all} and \code{exclude_all} parameters allow us to include or exclude
all attributes, and then specifically exclude or include the ones we need.

For the first and last days of the year, the year associated with the week may
be different from the year of the date, depending on the date type selected.

The week number associated with each date depends on the type of date dimension
selected: standard ('date'), ISO 8601 ('iso') or epidemiological ('epi').

The standard week numbers blocks of 7 days beginning on January 1. The last week
of the year can be less than 7 days long.

The ISO 8601 week numbers blocks of 7 days from Monday to Sunday. The first and
last week of the year can contain days from the previous or next year.

The epidemiological week is like ISO 8601 only that it considers that the week
begins on Sunday.
}
\examples{

td <- when() |>
  select_week_level(year_week = FALSE)

}
\seealso{
Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{define_instances}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_year_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
