% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_trial.R
\name{end_mab_trial}
\alias{end_mab_trial}
\title{Ends Multi-Arm Bandit Trial}
\usage{
end_mab_trial(data, bandits, algorithm, periods, conditions, ndraws)
}
\arguments{
\item{data}{Finalized data from \code{\link[=run_mab_trial]{run_mab_trial()}}.}

\item{bandits}{Finalized bandits list from \code{\link[=run_mab_trial]{run_mab_trial()}}.}

\item{algorithm}{A character string specifying the MAB algorithm to use. Options are "thompson" or "ucb1". Algorithm
defines the adaptive assignment process. Mathematical details on these algorithms
can be found in \href{https://arxiv.org/abs/1402.6028}{Kuleshov and Precup 2014} and
\href{https://arxiv.org/abs/1904.07272}{Slivkins 2024}.}

\item{periods}{Numeric value of length 1; total number of periods in Multi-Arm-Bandit trial.}

\item{ndraws}{A numeric value; When Thompson sampling direct calculations fail, draws from a simulated posterior
will be used to approximate the Thompson sampling probabilities. This is the number of simulations to use, the default
is 5000 to match the default parameter \code{\link[bandit:best_binomial_bandit_sim]{bandit::best_binomial_bandit_sim()}}, but might need to be raised or lowered depending on performance and accuracy
concerns.}
}
\value{
A named list containing:
\itemize{
\item \code{final_data}: The processed tibble or data.table, containing new columns pertaining to the results of the trial.
\item \code{bandits}: A tibble or data.table containing the UCB1 values or Thompson sampling posterior distributions for each period.
\item \code{assignment_probs}: A tibble or data.table containing the probability of being assigned each treatment arm at a given period.
}
}
\description{
Condenses output from \code{\link[=run_mab_trial]{run_mab_trial()}} into
manageable structure.
}
\details{
Takes the bandit lists provided, and condenses them using \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}
into tibbles or data.tables, and then pivots the table
to wide format where each treatment arm is a column, and the rows
represent periods.

At this step the final UCB1 or Thompson sampling probabilities are calculated.
The entire table is shifted backward by one period so that each row reflects the calculation
that occurs after completing a period. For example prior to this change, row 11, would indicate the calculations
from period 11 before assignment, but now that occured after period 11's imputations.

This has the impact of removing the original first row, where all the assignment
probabilities are equal, and modifying the last row to represent the final calculation after the conclusion
of the simulation.

The assignment probabilities are not changed in this way, so for each period
they still reflect the assignment probabilities used in that period.
}
\seealso{
\itemize{
\item \code{\link[=run_mab_trial]{run_mab_trial()}}
}
}
\keyword{internal}
