% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_mab_simulation.R
\name{condense_results}
\alias{condense_results}
\title{Condenses results into a list for \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}}
\usage{
condense_results(data, keep_data, mabs, times)
}
\arguments{
\item{data}{A data.frame, data.table, or tibble containing input data from the trial. This should be the results
of a traditional Randomized Controlled Trial (RCT). Any data.frames will be converted to tibbles internally.}

\item{keep_data}{Logical; Whether or not to keep the final data from each trial. Recommended FALSE.}

\item{mabs}{output from \code{\link[furrr:future_map]{furrr::future_map()}} in \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}}

\item{times}{A numeric value of length 1, the number of simulations to conduct.}
}
\value{
\code{multiple.mab} class object, which is a named list containing:
\itemize{
\item \verb{final_data_nest:} tibble or data.table containing the nested tibbles/data.tables from each trial. Only provided when \code{keep_data} is TRUE.
\item \code{bandits}: A tibble or data.table containing the UCB1 values or Thompson sampling posterior distributions for each period. Wide format,
each row is a period, and each columns is a treatment.
\item \code{assignment_probs}: A tibble or data.table containing the probability of being assigned each treatment arm at a given period. Wide format,
each row is a period, and each columns is a treatment.
\item \code{estimates}: A tibble or data.table containing the
AIPW (Augmented Inverse Probability Weighting) treatment effect estimates and variances, and traditional
sample means and variances, for each treatment arm. Long format, treatment arm, and estimate type are columns along with the mean
and variance.
\item \code{settings}: A named list of the configuration settings used in the trial.
}
}
\description{
Takes the output from \code{\link[furrr:future_map]{furrr::future_map()}} in \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}
and condenses it to return to the user.
}
\details{
This function iterates over every element in the output from \code{\link[furrr:future_map]{furrr::future_map()}}
and extracts the required element to place to condense into the final list, outputted to the user
in \link{multiple_mab_simulation}. It condenses the long list into tibbles or data.tables, keeping each element
together. For example it extracts all the \code{bandits} objects from the output lists, across all trials, and
binds them into a single tibble/data.table.
}
\keyword{internal}
