% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peirce.R
\name{peirce_anomalies}
\alias{peirce_anomalies}
\alias{chauvenet_anomalies}
\title{Anomalies according to Peirce's and Chauvenet's criteria}
\usage{
peirce_anomalies(y)

chauvenet_anomalies(y)
}
\arguments{
\item{y}{numerical vector of observations}
}
\value{
A logical vector
}
\description{
Peirce's criterion and Chauvenet's criterion were both proposed in the 1800s
as a way of determining what observations should be rejected in a univariate sample.
}
\details{
These functions take a univariate sample \code{y} and return a logical
vector indicating which observations should be considered anomalies according
to either Peirce's criterion or Chauvenet's criterion.
}
\examples{
y <- rnorm(1000)
tibble(y = y) |> filter(peirce_anomalies(y))
tibble(y = y) |> filter(chauvenet_anomalies(y))
}
\references{
Peirce, B. (1852). Criterion for the rejection of doubtful observations.
\emph{The Astronomical Journal}, 2(21), 161–163.

Chauvenet, W. (1863). 'Method of least squares'. Appendix to
\emph{Manual of Spherical and Practical Astronomy}, Vol.2, Lippincott, Philadelphia, pp.469-566.
}
\author{
Rob J Hyndman
}
