% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmplotting_helpers.R
\name{plotKM.band_subgroups}
\alias{plotKM.band_subgroups}
\title{Plot Kaplan-Meier Survival Difference Curves with Subgroups and Confidence Bands}
\usage{
plotKM.band_subgroups(
  df,
  tte.name,
  event.name,
  treat.name,
  weight.name = NULL,
  sg_labels = NULL,
  ltype = "s",
  lty = 1,
  draws = 20,
  lwd = 2,
  sg_colors = NULL,
  color = "lightgrey",
  ymax.pad = 0.01,
  ymin.pad = -0.01,
  taus = c(-Inf, Inf),
  yseq_length = 5,
  cex_Yaxis = 0.8,
  risk_cex = 0.8,
  by.risk = 6,
  risk.add = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  ymin.del = 0.035,
  y.risk1 = NULL,
  y.risk2 = NULL,
  ymin2 = NULL,
  risk_offset = NULL,
  risk.pad = 0.01,
  risk_delta = 0.0275,
  tau_add = NULL,
  time.zero.pad = 0,
  time.zero.label = 0,
  xlabel = NULL,
  ylabel = NULL,
  Maxtau = NULL,
  seedstart = 8316951,
  ylim = NULL,
  draws.band = 20,
  qtau = 0.025,
  show_resamples = FALSE,
  modify_tau = FALSE
)
}
\arguments{
\item{df}{Data frame containing survival data.}

\item{tte.name}{Name of the time-to-event column.}

\item{event.name}{Name of the event indicator column (0/1).}

\item{treat.name}{Name of the treatment group column (0/1).}

\item{weight.name}{Optional name of the weights column.}

\item{sg_labels}{Character vector of subgroup definitions (as logical expressions).}

\item{ltype}{Line type for curves (default: "s").}

\item{lty}{Line style for curves (default: 1).}

\item{draws}{Number of draws for resampling (default: 20).}

\item{lwd}{Line width for curves (default: 2).}

\item{sg_colors}{Colors for subgroup curves.}

\item{color}{Color for confidence band polygon (default: "lightgrey").}

\item{ymax.pad}{Padding for y-axis limits.}

\item{ymin.pad}{Padding for y-axis limits.}

\item{taus}{Vector for time truncation (default: c(-Inf, Inf)).}

\item{yseq_length}{Number of y-axis ticks (default: 5).}

\item{cex_Yaxis}{Text size for axis.}

\item{risk_cex}{Text size for risk table.}

\item{by.risk}{Interval for risk table time points (default: 6).}

\item{risk.add}{Additional time points for risk table.}

\item{xmax}{Additional graphical and calculation parameters.}

\item{ymin}{Additional graphical and calculation parameters.}

\item{ymax}{Additional graphical and calculation parameters.}

\item{ymin.del}{Additional graphical and calculation parameters.}

\item{y.risk1}{Additional graphical and calculation parameters.}

\item{y.risk2}{Additional graphical and calculation parameters.}

\item{ymin2}{Additional graphical and calculation parameters.}

\item{risk_offset}{Additional graphical and calculation parameters.}

\item{risk.pad}{Additional graphical and calculation parameters.}

\item{risk_delta}{Additional graphical and calculation parameters.}

\item{tau_add}{Additional graphical and calculation parameters.}

\item{time.zero.pad}{Additional graphical and calculation parameters.}

\item{time.zero.label}{Additional graphical and calculation parameters.}

\item{xlabel}{Additional graphical and calculation parameters.}

\item{ylabel}{Additional graphical and calculation parameters.}

\item{Maxtau}{Additional graphical and calculation parameters.}

\item{seedstart}{Additional graphical and calculation parameters.}

\item{ylim}{Additional graphical and calculation parameters.}

\item{draws.band}{Number of draws for simultaneous confidence bands (default: 20).}

\item{qtau}{Quantile for time range in simultaneous bands (default: 0.025).}

\item{show_resamples}{Logical; whether to plot resampled curves (default: FALSE).}

\item{modify_tau}{Logical; restrict time range for bands.}
}
\value{
(Invisible) list containing KM_diff results, time points, subgroup curves, risk tables, and confidence intervals.
}
\description{
Plots the difference in Kaplan-Meier survival curves between two groups, optionally including simultaneous confidence bands and subgroup curves. Also displays risk tables for the overall population and specified subgroups.
}
