% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.htest.R
\name{plot.htest}
\alias{plot.htest}
\title{Plotting distribution of statistic for object "htest"}
\usage{
\method{plot}{htest}(x, ...)
}
\arguments{
\item{x}{object of class "htest"}

\item{...}{further arguments to ggplot}
}
\value{
a ggplot or NULL
}
\description{
Plotting distribution of statistic for object "htest"
}
\examples{

require(moonBook)
require(webr)
## chi-square test
x=chisq.test(table(mtcars$am,mtcars$cyl))
plot(x)

#Welch Two Sample t-test
x=t.test(mpg~am,data=mtcars)
plot(x)
\donttest{
x=t.test(BMI~sex,data=acs)
plot(x)

# F test to compare two variances
x=var.test(age~sex,data=acs,alternative="less")
plot(x)

# Paired t-test
x=t.test(iris$Sepal.Length,iris$Sepal.Width,paired=TRUE)
plot(x)

# One sample t-test
plot(t.test(acs$age,mu=63))

# Two sample t-test
x=t.test(age~sex, data=acs,conf.level=0.99,alternative="greater",var.equal=TRUE)
plot(x)
}
}
